/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.configuration;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.configuration.IConfigurationPageContainer;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationPage
extends EventManager {
    public static final int PROP_TITLE = 1;
    public static final int PROP_DIRTY = 257;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationPage.class);
    private IConfigurationPageContainer container;
    private PageForm mform;
    private DataBindingContext bindingContext;
    private String title;
    private String titleToolTip;
    private Image titleImage;

    public void addPropertyListener(IPropertyListener listener) {
        this.addListenerObject(listener);
    }

    protected void createFormContent(IManagedForm managedForm) {
    }

    public void createPage(Composite parent, FormToolkit toolkit) {
        ScrolledForm form = toolkit.createScrolledForm(parent);
        this.mform = new PageForm(this, form, toolkit);
        BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ConfigurationPage.this.createFormContent((IManagedForm)ConfigurationPage.this.mform);
            }
        });
    }

    public void dispose() {
        if (this.mform != null) {
            this.mform.dispose();
        }
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        this.clearListeners();
    }

    protected void firePropertyChange(int propertyId) {
        Object[] array = this.getListeners();
        int nX = 0;
        while (nX < array.length) {
            IPropertyListener l = (IPropertyListener)array[nX];
            try {
                l.propertyChanged((Object)this, propertyId);
            }
            catch (RuntimeException e) {
                LOG.error("Error notifying listener {}. {}", new Object[]{l, e.getMessage(), e});
            }
            ++nX;
        }
    }

    public DataBindingContext getBindingContext() {
        if (this.bindingContext == null) {
            Realm realm = SWTObservables.getRealm((Display)PlatformUI.getWorkbench().getDisplay());
            this.bindingContext = new DataBindingContext(realm);
        }
        return this.bindingContext;
    }

    public IConfigurationPageContainer getContainer() {
        return this.container;
    }

    public Control getControl() {
        return this.mform != null ? this.mform.getForm() : null;
    }

    public IManagedForm getManagedForm() {
        return this.mform;
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    public Image getTitleImage() {
        return this.titleImage;
    }

    public String getTitleToolTip() {
        return this.titleToolTip != null ? this.titleToolTip : "";
    }

    public boolean isActive() {
        return ((Object)((Object)this)).equals((Object)this.container.getActivePageInstance());
    }

    public boolean isDirty() {
        if (this.mform != null) {
            return this.mform.isDirty();
        }
        return false;
    }

    public IStatus performSave(IProgressMonitor monitor) {
        if (this.mform != null) {
            this.mform.commit(true);
            this.firePropertyChange(257);
        }
        return Status.OK_STATUS;
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.removeListenerObject(listener);
    }

    public void setActive(boolean active) {
        if (active && this.mform != null && this.mform.isStale()) {
            this.mform.refresh();
        }
    }

    public void setContainer(IConfigurationPageContainer container) {
        this.container = container;
    }

    protected void setTitle(String title) {
        this.title = title;
        this.firePropertyChange(1);
    }

    protected void setTitleImage(Image titleImage) {
        Image oldImage = this.titleImage;
        if (oldImage != null && oldImage.equals(titleImage)) {
            return;
        }
        this.titleImage = titleImage;
        this.firePropertyChange(1);
    }

    protected void setTitleToolTip(String titleToolTip) {
        this.titleToolTip = titleToolTip;
        this.firePropertyChange(1);
    }

    private static class PageForm
    extends ManagedForm {
        public PageForm(ConfigurationPage page, ScrolledForm form, FormToolkit toolkit) {
            super(toolkit, form);
            this.setContainer((Object)page);
        }

        public void dirtyStateChanged() {
            this.getPage().firePropertyChange(257);
        }

        public ConfigurationPage getPage() {
            return (ConfigurationPage)((Object)this.getContainer());
        }

        public void staleStateChanged() {
            if (this.getForm().isDisposed()) {
                return;
            }
            if (this.getPage().isActive()) {
                this.refresh();
            }
        }
    }
}

