/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.kohsuke.args4j.Argument;

public class LsCmd
extends Command {
    @Argument(index=0, usage="specify what to list (schedules, jobs or providers)", required=true, metaVar="WHAT")
    String what;
    @Argument(index=1, usage="an optional filter string", required=false, metaVar="FILTER")
    String searchString;

    public LsCmd() {
        super("<schedules|jobs|providers> <contextPath> [<filterString>] - lists schedules or jobs");
    }

    protected void doExecute() throws Exception {
        if (StringUtils.isBlank((String)this.what)) {
            this.printf("ERROR: please specify what to list", new Object[0]);
            return;
        }
        if (StringUtils.startsWith((String)"providers", (String)this.what)) {
            this.printProviders();
        } else if (StringUtils.startsWith((String)"schedules", (String)this.what)) {
            this.printSchedules();
        } else if (StringUtils.startsWith((String)"jobs", (String)this.what)) {
            this.printJobs();
        }
    }

    private void printJobs() {
    }

    private void printProviders() {
        TreeSet<String> providers = new TreeSet<String>(JobsActivator.getInstance().getJobProviderRegistry().getProviders());
        for (String id : providers) {
            if (!StringUtils.isBlank((String)this.searchString) && !StringUtils.contains((String)id, (String)this.searchString)) continue;
            this.printf(id, new Object[0]);
        }
    }

    private void printSchedule(ISchedule schedule) {
        StrBuilder info = new StrBuilder();
        info.append(schedule.getId());
        if (!schedule.isEnabled()) {
            info.appendln(" DISABLED");
        }
        TimeZone timeZone = schedule.getTimeZone();
        info.append("  time zone: ").append(timeZone.getDisplayName(false, 1, Locale.US)).appendln(timeZone.useDaylightTime() ? " (will adjust to daylight changes)" : " (independent of daylight changes)");
        info.append("      queue: ").appendln(schedule.getQueueId() != null ? schedule.getQueueId() : "(default)");
        String prefix = "    entries: ";
        List<IScheduleEntry> entries = schedule.getEntries();
        if (!entries.isEmpty()) {
            for (IScheduleEntry entry : entries) {
                info.append(prefix).append(entry.getId()).append(' ').append(entry.getCronExpression()).append(' ').append(entry.getJobTypeId()).appendNewLine();
                prefix = "             ";
                Map<String, String> parameter = entry.getJobParameter();
                if (parameter.isEmpty()) continue;
                Set<Map.Entry<String, String>> entrySet = parameter.entrySet();
                for (Map.Entry<String, String> param : entrySet) {
                    info.append(prefix).append("    ").append(param.getKey()).append('=').appendln(param.getValue());
                }
            }
        } else {
            info.append(prefix).appendln("(none)");
        }
        this.printf("%s", new Object[]{info.toString()});
    }

    private void printSchedules() throws Exception {
        String externalId;
        TreeSet<String> storageIds = new TreeSet<String>(Arrays.asList(ScheduleStore.getSchedules()));
        if (StringUtils.isNotBlank((String)this.searchString)) {
            for (String storageId : storageIds) {
                ScheduleImpl schedule;
                externalId = ScheduleManagerImpl.getExternalId(storageId);
                if (!StringUtils.equals((String)this.searchString, (String)externalId) || (schedule = ScheduleStore.load(storageId, externalId, false)) == null) continue;
                this.printSchedule(schedule);
                return;
            }
        }
        for (String storageId : storageIds) {
            externalId = ScheduleManagerImpl.getExternalId(storageId);
            if (!StringUtils.isBlank((String)this.searchString) && !StringUtils.contains((String)storageId, (String)this.searchString)) continue;
            this.printf("%s (storage key %s)", new Object[]{externalId, storageId});
        }
    }
}

