/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.schedules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleWorkingCopy;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ScheduleImpl
implements ISchedule,
IScheduleWorkingCopy {
    private static final String JOBS = "jobs";
    public static final String TIME_ZONE = "timeZone";
    public static final String ENABLED = "enabled";
    public static final String QUEUE_ID = "queueId";
    public static final String CONTEXT_PATH = "contextPath";
    private final IEclipsePreferences node;
    private final String id;
    private IPath contextPath;
    private String queueId;
    private boolean enabled;
    private TimeZone timeZone;
    private Map<String, ScheduleEntryImpl> entriesById;

    public ScheduleImpl(String id, Preferences node) throws BackingStoreException {
        this.id = id;
        this.node = (IEclipsePreferences)node;
    }

    @Override
    public ScheduleEntryImpl createEntry(String entryId) {
        if (!IdHelper.isValidId((String)entryId)) {
            throw new IllegalArgumentException("invalid id: " + this.id);
        }
        if (this.entriesById == null) {
            this.entriesById = new HashMap<String, ScheduleEntryImpl>(4);
        } else if (this.entriesById.containsKey(entryId)) {
            throw new IllegalStateException(String.format("entry '%s' already exists", entryId));
        }
        ScheduleEntryImpl entry = new ScheduleEntryImpl(entryId);
        this.entriesById.put(entryId, entry);
        return entry;
    }

    public IPath getContextPath() {
        IPath path = this.contextPath;
        if (path == null) {
            throw new IllegalStateException(String.format("Schedule %s is invalid. Its context path is missing! Please delete and re-create schedule.", this.id));
        }
        return path;
    }

    @Override
    public List<IScheduleEntry> getEntries() {
        if (this.entriesById != null) {
            Collection<ScheduleEntryImpl> values = this.entriesById.values();
            ArrayList<ScheduleEntryImpl> entries = new ArrayList<ScheduleEntryImpl>(values.size());
            entries.addAll(values);
            return Collections.unmodifiableList(entries);
        }
        return Collections.emptyList();
    }

    private Preferences getEntriesNode() {
        return this.node.node(JOBS);
    }

    @Override
    public ScheduleEntryImpl getEntry(String entryId) {
        ScheduleEntryImpl entry;
        if (!IdHelper.isValidId((String)entryId)) {
            throw new IllegalArgumentException("invalid id: " + this.id);
        }
        ScheduleEntryImpl scheduleEntryImpl = entry = this.entriesById != null ? this.entriesById.get(entryId) : null;
        if (entry == null) {
            throw new IllegalStateException(String.format("entry '%s' does not exist", entryId));
        }
        return entry;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public IEclipsePreferences getPreferenceNode() {
        return this.node;
    }

    @Override
    public String getQueueId() {
        return this.queueId;
    }

    public String getStorageKey() {
        return this.node.name();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone != null ? this.timeZone : DateUtils.UTC_TIME_ZONE;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ScheduleImpl load() throws BackingStoreException {
        this.queueId = this.node.get(QUEUE_ID, null);
        this.enabled = this.node.getBoolean(ENABLED, false);
        if (this.node.get(CONTEXT_PATH, null) == null) {
            throw new IllegalStateException(String.format("Schedule %s is invalid. Its context path is missing! Please delete and re-create.", this.id));
        }
        this.contextPath = new Path(this.node.get(CONTEXT_PATH, null));
        this.timeZone = TimeZone.getTimeZone(this.node.get(TIME_ZONE, "GMT"));
        Preferences jobs = this.getEntriesNode();
        String[] childrenNames = jobs.childrenNames();
        this.entriesById = new HashMap<String, ScheduleEntryImpl>(childrenNames.length);
        String[] stringArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String jobName = stringArray[n2];
            ScheduleEntryImpl entryImpl = new ScheduleEntryImpl(jobName);
            entryImpl.load(jobs.node(jobName));
            this.entriesById.put(jobName, entryImpl);
            ++n2;
        }
        return this;
    }

    public void save() throws BackingStoreException {
        String tz;
        if (StringUtils.isNotBlank((String)this.queueId)) {
            this.node.put(QUEUE_ID, this.queueId);
        } else {
            this.node.remove(QUEUE_ID);
        }
        this.node.put(CONTEXT_PATH, this.getContextPath().toString());
        this.node.putBoolean(ENABLED, this.enabled);
        String string = tz = this.timeZone != null ? this.timeZone.getID() : null;
        if (tz != null && !DateUtils.UTC_TIME_ZONE.getID().equals(tz)) {
            this.node.put(TIME_ZONE, tz);
        } else {
            this.node.remove(TIME_ZONE);
        }
        Preferences jobs = this.getEntriesNode();
        if (this.entriesById != null) {
            for (ScheduleEntryImpl entry : this.entriesById.values()) {
                entry.saveWithoutFlush(jobs.node(entry.getId()));
            }
            String[] stringArray = jobs.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String jobName = stringArray[n2];
                if (!this.entriesById.containsKey(jobName) && jobs.nodeExists(jobName)) {
                    jobs.node(jobName).removeNode();
                }
                ++n2;
            }
        } else {
            jobs.removeNode();
        }
        this.node.flush();
    }

    public void setContextPath(IPath contextPath) {
        if (contextPath == null) {
            throw new IllegalArgumentException("Context path must not be null!");
        }
        this.contextPath = contextPath;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ScheduleImpl [id=").append(this.id).append(", enabled=").append(this.enabled).append(", queueId=").append(this.queueId).append(", timeZone=").append(this.timeZone).append("]");
        return builder.toString();
    }
}

