/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.installer;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.P2Debug;
import org.eclipse.gyrex.p2.internal.installer.PackageInstallState;
import org.eclipse.gyrex.p2.internal.installer.PackageInstallerJob;
import org.eclipse.gyrex.p2.internal.packages.IPackageManager;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageScanner
extends Job {
    private static final Logger LOG = LoggerFactory.getLogger(PackageScanner.class);
    static final long INITIAL_SLEEP_TIME = TimeUnit.MINUTES.toMillis(3L);
    static final long MAX_SLEEP_TIME = TimeUnit.HOURS.toMillis(2L);
    private static final AtomicReference<PackageScanner> instanceRef = new AtomicReference();
    private long sleepTime = INITIAL_SLEEP_TIME;

    public static PackageScanner getInstance() {
        PackageScanner scanner = instanceRef.get();
        if (scanner != null) {
            return scanner;
        }
        instanceRef.compareAndSet(null, new PackageScanner());
        return instanceRef.get();
    }

    PackageScanner() {
        super("Software Package Scanner");
        this.setSystem(true);
        this.setPriority(30);
        this.setRule(new MutexRule(PackageScanner.class));
    }

    private IStatus doRun(IProgressMonitor monitor) {
        IProvisioningAgent agent = null;
        try {
            INodeEnvironment nodeEnvironment = (INodeEnvironment)P2Activator.getInstance().getService(INodeEnvironment.class);
            agent = ((IProvisioningAgentProvider)P2Activator.getInstance().getService(IProvisioningAgentProvider.class)).createAgent(null);
            if (agent == null) {
                throw new IllegalStateException("The current system has not been provisioned using p2. Unable to acquire provisioning agent.");
            }
            HashSet<PackageDefinition> packagesToInstall = new HashSet<PackageDefinition>();
            HashSet<PackageDefinition> packagesToRemove = new HashSet<PackageDefinition>();
            IPackageManager packageManager = P2Activator.getInstance().getPackageManager();
            Collection<PackageDefinition> packages = packageManager.getPackages();
            for (PackageDefinition packageDefinition : packages) {
                block23: {
                    if (StringUtils.isNotBlank((String)packageDefinition.getNodeFilter())) {
                        try {
                            if (!nodeEnvironment.matches(packageDefinition.getNodeFilter())) {
                                if (!P2Debug.nodeInstallation) continue;
                                LOG.debug("Ignoring package {}. Not applicable to current node.", (Object)packageDefinition.getId());
                            }
                            break block23;
                        }
                        catch (InvalidSyntaxException e) {
                            if (!P2Debug.nodeInstallation) continue;
                            LOG.debug("Ignoring package {}. Error in node filter syntax: {}", (Object)packageDefinition.getId(), (Object)e.getMessage());
                        }
                        continue;
                    }
                }
                boolean installed = PackageInstallState.isInstalled(agent, packageDefinition);
                if (packageManager.isMarkedForInstall(packageDefinition)) {
                    if (!installed) {
                        if (P2Debug.nodeInstallation) {
                            LOG.debug("Found new package to install: {}", (Object)packageDefinition.getId());
                        }
                        packagesToInstall.add(packageDefinition);
                        continue;
                    }
                    if (!P2Debug.nodeInstallation) continue;
                    LOG.debug("Package {} already installed. Will be ignored.", (Object)packageDefinition.getId());
                    continue;
                }
                if (packageManager.isMarkedForUninstall(packageDefinition)) {
                    if (installed) {
                        if (P2Debug.nodeInstallation) {
                            LOG.debug("Found package that should be removed: {}", (Object)packageDefinition.getId());
                        }
                        packagesToRemove.add(packageDefinition);
                        continue;
                    }
                    if (!P2Debug.nodeInstallation) continue;
                    LOG.debug("Package {} not installed. Will be ignored.", (Object)packageDefinition.getId());
                    continue;
                }
                if (!P2Debug.nodeInstallation) continue;
                LOG.debug("Package {} neither marked for installation nor for removal. Will be ignored.", (Object)packageDefinition.getId());
            }
            if (packagesToInstall.isEmpty() && packagesToRemove.isEmpty() && PackageInstallState.getActiveInstallSessionId() == null) {
                if (P2Debug.nodeInstallation) {
                    LOG.debug("Nothing to install or remove.");
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            LOG.info("Pending software package modifications found. Scheduling software installation for local node.");
            PackageInstallerJob packageInstallerJob = new PackageInstallerJob(packagesToInstall, packagesToRemove);
            packageInstallerJob.schedule(500L);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (IllegalStateException e) {
            LOG.warn("Unable to for new software packages. System does not seem to be ready. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            LOG.error("Error while checking for new or revoked software packages. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            if (agent != null) {
                agent.stop();
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IStatus status = this.doRun(monitor);
            this.sleepTime = !status.isOK() ? Math.min(this.sleepTime * 2L, MAX_SLEEP_TIME) : INITIAL_SLEEP_TIME;
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (P2Debug.nodeInstallation) {
                LOG.debug("Rescheduling installer to run again in {} minutes", (Object)TimeUnit.MILLISECONDS.toMinutes(this.sleepTime));
            }
            this.schedule(this.sleepTime);
        }
    }

    static class MutexRule
    implements ISchedulingRule {
        private final Object object;

        public MutexRule(Object object) {
            this.object = object;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof MutexRule) {
                return this.object.equals(((MutexRule)rule).object);
            }
            return false;
        }
    }
}

