/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.kohsuke.args4j.Argument;

public class ImportCmd
extends Command {
    private static final String FILE_EXT_EPF = ".epf";
    @Argument(index=0, required=true, usage="file to import from")
    File file;

    public ImportCmd() {
        super("<file> - import preferences from file");
    }

    protected void doExecute() throws Exception {
        IPreferencesService preferencesService = EclipsePreferencesUtil.getPreferencesService();
        if (!StringUtils.endsWithIgnoreCase((String)this.file.getName(), (String)FILE_EXT_EPF)) {
            this.file = new File(this.file.getParentFile(), this.file.getName().concat(FILE_EXT_EPF));
        }
        if (!this.file.isFile() || !this.file.canRead()) {
            this.printf("ERROR: Unable to read file %s", new Object[]{this.file.getAbsolutePath()});
            return;
        }
        IEclipsePreferences node = preferencesService.getRootNode();
        String path = this.ci.nextArgument();
        if (StringUtils.isNotBlank((String)path)) {
            node = (IEclipsePreferences)node.node(path);
        }
        FileInputStream in = FileUtils.openInputStream((File)this.file);
        try {
            preferencesService.importPreferences((InputStream)in);
            this.printf("Successfully imported preferences from %s.", new Object[]{node.absolutePath(), this.file.getAbsolutePath()});
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

