/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.internal.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.common.internal.services.BundleDelegatingClassLoader;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.common.services.ServiceNotAvailableException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceProxy<T>
implements IServiceProxy<T>,
InvocationHandler {
    private final Class<T> serviceInterface;
    private final AtomicReference<ServiceTracker<T, T>> serviceTrackerRef = new AtomicReference();
    private final AtomicReference<BundleContext> bundleContextRef = new AtomicReference();
    private volatile T dynamicProxy;

    public ServiceProxy(BundleContext bundleContext, Class<T> serviceInterface) {
        this.serviceInterface = serviceInterface;
        this.bundleContextRef.set(bundleContext);
        this.serviceTrackerRef.set(new ServiceTracker(bundleContext, serviceInterface, null));
    }

    public ServiceProxy(BundleContext bundleContext, Class<T> serviceInterface, Filter filter) {
        this.serviceInterface = serviceInterface;
        this.bundleContextRef.set(bundleContext);
        this.serviceTrackerRef.set(new ServiceTracker(bundleContext, filter, null));
    }

    private T createProxy() {
        BundleContext bundleContext = this.bundleContextRef.get();
        if (bundleContext == null) {
            throw new IllegalStateException("inactive");
        }
        return (T)Proxy.newProxyInstance(new BundleDelegatingClassLoader(bundleContext.getBundle()), new Class[]{this.serviceInterface}, (InvocationHandler)this);
    }

    @Override
    public void dispose() {
        this.bundleContextRef.set(null);
        ServiceTracker tracker = this.serviceTrackerRef.getAndSet(null);
        if (tracker != null) {
            tracker.close();
        }
        this.dynamicProxy = null;
    }

    @Override
    public T getProxy() {
        if (this.dynamicProxy != null) {
            return this.dynamicProxy;
        }
        this.dynamicProxy = this.createProxy();
        return this.dynamicProxy;
    }

    @Override
    public T getService() throws ServiceNotAvailableException {
        ServiceTracker<T, T> serviceTracker = this.serviceTrackerRef.get();
        if (serviceTracker == null) {
            throw new ServiceNotAvailableException(this.bundleContextRef.get(), this.serviceInterface.getName());
        }
        serviceTracker.open();
        Object service = serviceTracker.getService();
        if (service == null) {
            throw new ServiceNotAvailableException(this.bundleContextRef.get(), this.serviceInterface.getName());
        }
        return (T)service;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke(this.getService(), args);
    }
}

