/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class ContextConsoleCommands
implements CommandProvider {
    static final Map<String, Command> commands = new TreeMap<String, Command>();

    static {
        commands.put("ls", new Command("list defined contexts"){

            @Override
            public void execute(ContextRegistryImpl registry, CommandInterpreter ci) throws Exception {
                Collection<ContextDefinition> contexts = registry.getDefinedContexts();
                TreeMap<String, ContextDefinition> sortedContexts = new TreeMap<String, ContextDefinition>();
                for (ContextDefinition contextDefinition : contexts) {
                    sortedContexts.put(contextDefinition.getPath().toString(), contextDefinition);
                }
                for (String key : sortedContexts.keySet()) {
                    ci.println(sortedContexts.get(key));
                }
            }
        });
        commands.put("define", new Command("<path> <name> - defines a context"){

            @Override
            public void execute(ContextRegistryImpl registry, CommandInterpreter ci) throws Exception {
                String pathStr = ci.nextArgument();
                if (StringUtils.isBlank((String)pathStr) || !Path.EMPTY.isValidPath(pathStr)) {
                    ci.println((Object)"ERROR: invalid path");
                    ci.println((Object)this.getHelp());
                    return;
                }
                String name = ci.nextArgument();
                if (StringUtils.isBlank((String)name)) {
                    ci.println((Object)"ERROR: invalid name");
                    ci.println((Object)this.getHelp());
                    return;
                }
                ContextDefinition definition = new ContextDefinition((IPath)new Path(pathStr));
                definition.setName(name);
                registry.saveDefinition(definition);
                ci.println((Object)"context added");
            }
        });
        commands.put("rm", new Command("<path> - removes a context"){

            @Override
            public void execute(ContextRegistryImpl registry, CommandInterpreter ci) throws Exception {
                String pathStr = ci.nextArgument();
                if (StringUtils.isBlank((String)pathStr) || !Path.EMPTY.isValidPath(pathStr)) {
                    ci.println((Object)"ERROR: invalid path");
                    ci.println((Object)this.getHelp());
                    return;
                }
                registry.removeDefinition(new ContextDefinition((IPath)new Path(pathStr)));
                ci.println((Object)"context removed");
            }
        });
        commands.put("flush", new Command("<path> - flushes a context"){

            @Override
            public void execute(ContextRegistryImpl registry, CommandInterpreter ci) throws Exception {
                String pathStr = ci.nextArgument();
                if (StringUtils.isBlank((String)pathStr) || !Path.EMPTY.isValidPath(pathStr)) {
                    ci.println((Object)"ERROR: invalid path");
                    ci.println((Object)this.getHelp());
                    return;
                }
                GyrexContextHandle contextHandle = registry.get((IPath)new Path(pathStr));
                if (contextHandle == null) {
                    ci.println((Object)"ERROR: context not found");
                    return;
                }
                registry.flushContextHierarchy(contextHandle);
                ci.println((Object)"context flushed");
            }
        });
    }

    static void printHelp(CommandInterpreter ci) {
        ci.println((Object)"context <cmd> [args]");
        for (String cmd : commands.keySet()) {
            ci.println((Object)("\t" + cmd + " " + commands.get(cmd).getHelp()));
        }
    }

    public void _context(CommandInterpreter ci) throws Exception {
        String command = ci.nextArgument();
        if (command == null) {
            ContextConsoleCommands.printHelp(ci);
            return;
        }
        Command cmd = commands.get(command);
        if (cmd == null) {
            ci.println((Object)("ERROR: unknown command " + command));
            ContextConsoleCommands.printHelp(ci);
            return;
        }
        ContextRegistryImpl registry = null;
        try {
            registry = ContextActivator.getInstance().getContextRegistryImpl();
        }
        catch (IllegalStateException illegalStateException) {
            ci.println((Object)"ERROR: Context registry not available!");
            return;
        }
        try {
            cmd.execute(registry, ci);
        }
        catch (Exception e) {
            if (ContextDebug.debug) {
                ci.printStackTrace((Throwable)e);
            }
            ci.println((Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        help.appendln("---Runtime Context Commands---");
        help.appendln("\tcontext <cmd> [args]");
        for (String cmd : commands.keySet()) {
            help.appendln("\t\t" + cmd + " " + commands.get(cmd).getHelp());
        }
        return help.toString();
    }

    static abstract class Command {
        private final String help;

        public Command(String help) {
            this.help = help;
        }

        public abstract void execute(ContextRegistryImpl var1, CommandInterpreter var2) throws Exception;

        public String getHelp() {
            return this.help;
        }

        protected void printInvalidArgs(String errorMessage, CommandInterpreter ci) {
            ci.println((Object)("ERROR: invalid arguments: " + errorMessage));
            ci.println((Object)("\t" + this.getHelp()));
        }
    }
}

