/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.UrlUtil;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.Handler;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlMap {
    private static final Logger LOG = LoggerFactory.getLogger(UrlMap.class);
    private static final Integer ANY_PORT = new Integer(-1);
    private static final String EMPTY_STRING = "";
    private final Map<String, Map<Integer, PathMap>> hostsToPortsToPathsForHttp = new HashMap<String, Map<Integer, PathMap>>(5);
    private final Map<String, Map<Integer, PathMap>> hostsToPortsToPathsForHttps = new HashMap<String, Map<Integer, PathMap>>(5);

    private static int getEstimatedCapacity(String domain) {
        if (domain.isEmpty() || "localhost".equals(domain)) {
            return 12;
        }
        return 1;
    }

    private Map<String, Map<Integer, PathMap>> getHostsToPortsToPathMap(String protocol) {
        if ("http".equals(protocol)) {
            return this.hostsToPortsToPathsForHttp;
        }
        if ("https".equals(protocol)) {
            return this.hostsToPortsToPathsForHttps;
        }
        return null;
    }

    public PathMap.Entry getMatch(String protocol, String domain, int port, String path) {
        if (protocol == null || domain == null || path == null || !path.startsWith("/")) {
            return null;
        }
        Map<String, Map<Integer, PathMap>> hostsToPortsToPathMap = this.getHostsToPortsToPathMap(protocol);
        if (hostsToPortsToPathMap == null) {
            if (JettyDebug.urlMapLookup) {
                Object[] objectArray = new Object[5];
                objectArray[0] = protocol;
                objectArray[1] = domain;
                objectArray[2] = port;
                objectArray[3] = path;
                LOG.debug("[URLMAP] no map for protocol {}://{}:{}{} --> {}", objectArray);
            }
            return null;
        }
        domain = UrlUtil.normalizeDomain(domain);
        PathMap.Entry match = null;
        boolean continueMatching = true;
        while (match == null && continueMatching) {
            Map<Integer, PathMap> portsToPathMap;
            if (JettyDebug.urlMapLookup) {
                LOG.debug("[URLMAP] match loop {}://{}:{}{}", new Object[]{protocol, domain, port, path});
            }
            if ((portsToPathMap = hostsToPortsToPathMap.get(domain)) == null && JettyDebug.urlMapLookup) {
                LOG.debug("[URLMAP] no map for domain {}://{}:{}{} --> {}", new Object[]{protocol, domain, port, path, match});
            }
            if (!domain.isEmpty()) {
                int separatorIndex = domain.indexOf(46);
                domain = separatorIndex >= 0 ? domain.substring(separatorIndex + 1) : EMPTY_STRING;
            } else {
                continueMatching = false;
            }
            if (portsToPathMap == null) continue;
            PathMap pathMap = portsToPathMap.get(port);
            if (pathMap != null && !pathMap.isEmpty() && (match = pathMap.getMatch(path)) != null) {
                if (JettyDebug.urlMapLookup) {
                    LOG.debug("[URLMAP] direct port match {}://{}:{}{} --> {}", new Object[]{protocol, domain, port, path, match});
                }
                return match;
            }
            pathMap = portsToPathMap.get(ANY_PORT);
            if (pathMap == null || pathMap.isEmpty() || (match = pathMap.getMatch(path)) == null) continue;
            if (JettyDebug.urlMapLookup) {
                LOG.debug("[URLMAP] any port match {}://{}:{}{} --> {}", new Object[]{protocol, domain, port, path, match});
            }
            return match;
        }
        if (JettyDebug.urlMapLookup) {
            LOG.debug("[URLMAP] done match {}://{}:{}{} --> {}", new Object[]{protocol, domain, port, path, match});
        }
        return match;
    }

    public boolean put(String url, Handler handler) {
        String path;
        PathMap pathMap;
        Object old;
        Integer port;
        Map<Integer, PathMap> portsToPathMap;
        URL parsedUrl;
        try {
            parsedUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid url: " + url, e);
        }
        String protocol = UrlUtil.getNormalizedProtocol(parsedUrl);
        Map<String, Map<Integer, PathMap>> hostsToPortsToPathMap = this.getHostsToPortsToPathMap(protocol);
        if (hostsToPortsToPathMap == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Protocol {0} not support for url {1}.", (Object)protocol, (Object)parsedUrl.toExternalForm()));
        }
        String domain = UrlUtil.getNormalizedDomain(parsedUrl);
        if (!hostsToPortsToPathMap.containsKey(domain)) {
            hostsToPortsToPathMap.put(domain, new HashMap(1));
        }
        if (!(portsToPathMap = hostsToPortsToPathMap.get(domain)).containsKey(port = new Integer(UrlUtil.getNormalizedPort(parsedUrl)))) {
            portsToPathMap.put(port, new PathMap(UrlMap.getEstimatedCapacity(domain)));
        }
        return (old = (pathMap = portsToPathMap.get(port)).put((Object)((path = "/".equals(path = UrlUtil.getNormalizedPath(parsedUrl)) ? "/*" : path.concat("/*")).length() == 0 ? "/" : path), (Object)handler)) == null;
    }
}

