/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.widgets;

import java.io.File;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.widgets.IUploadConfiguration;
import org.eclipse.rwt.widgets.UploadAdapter;
import org.eclipse.rwt.widgets.UploadEvent;
import org.eclipse.rwt.widgets.UploadItem;
import org.eclipse.rwt.widgets.UploadListener;
import org.eclipse.rwt.widgets.internal.uploadkit.IUploadAdapter;
import org.eclipse.rwt.widgets.internal.uploadkit.UploadThemeAdapter;
import org.eclipse.rwt.widgets.upload.servlet.FileUploadServiceHandler;
import org.eclipse.rwt.widgets.upload.servlet.FileUploadStorage;
import org.eclipse.rwt.widgets.upload.servlet.FileUploadStorageItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Upload
extends Control {
    public static final int SHOW_PROGRESS = 1;
    public static final int FIRE_PROGRESS_EVENTS = 4;
    public static final int SHOW_UPLOAD_BUTTON = 2;
    private String lastFileUploaded;
    private final String servlet;
    private String path;
    private boolean performUpload = false;
    private boolean resetUpload = false;
    private int flags;
    private UploadLCAAdapter uploadLCAAdapter;
    private String browseButtonText = "Browse";
    private String uploadButtonText = "Upload";
    private boolean[] uploadInProgresses = new boolean[1];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        FileUploadServiceHandler.register();
    }

    public Upload(Composite parent, int style, String servlet, boolean showProgress) {
        this(parent, style, servlet, (showProgress ? 1 : 0) | 2);
    }

    public Upload(Composite parent, int style, String servlet) {
        this(parent, style, servlet, 0);
    }

    public Upload(Composite parent, int style, String servlet, int flags) {
        super(parent, style);
        this.servlet = servlet == null ? FileUploadServiceHandler.getUrl(this.getWidgetId()) : servlet;
        this.flags = flags;
        if ((this.flags & 1) > 0) {
            this.flags |= 4;
        }
        this.lastFileUploaded = "";
        this.path = "";
        FileUploadStorage.getInstance().setUploadStorageItem(this.getWidgetId(), new FileUploadStorageItem());
    }

    public Upload(Composite parent, int style, int flags) {
        this(parent, style, null, flags);
    }

    public Upload(Composite parent, int style) {
        this(parent, style, null, 0);
    }

    public String getServlet() {
        this.checkWidget();
        return this.servlet;
    }

    public String getPath() {
        this.checkWidget();
        return this.path;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performUpload() {
        this.checkWidget();
        this.resetStorageItem();
        final boolean[] uploadSuccessful = new boolean[1];
        if (this.getPath() == null) return uploadSuccessful[0];
        if ("".equals(this.getPath())) return uploadSuccessful[0];
        if (!this.isEnabled()) return uploadSuccessful[0];
        if (this.uploadInProgresses[0]) return uploadSuccessful[0];
        this.performUpload = true;
        UploadAdapter listener = new UploadAdapter(){

            public void uploadFinished(UploadEvent event) {
                ((Upload)Upload.this).uploadInProgresses[0] = false;
                uploadSuccessful[0] = true;
            }

            public void uploadException(UploadEvent uploadEvent) {
                ((Upload)Upload.this).uploadInProgresses[0] = false;
            }
        };
        this.addUploadListener(listener);
        this.uploadInProgresses[0] = true;
        try {
            block8: {
                block7: {
                    if (!true) break block7;
                    if (!this.uploadInProgresses[0]) return uploadSuccessful[0];
                    if (this.isDisposed()) break block8;
                }
                do {
                    if (!this.getDisplay().readAndDispatch()) {
                        this.getDisplay().sleep();
                    }
                    if (!this.uploadInProgresses[0]) return uploadSuccessful[0];
                } while (!this.isDisposed());
            }
            return uploadSuccessful[0];
        }
        finally {
            this.uploadInProgresses[0] = false;
            this.performUpload = false;
            if (!this.isDisposed()) {
                this.removeUploadListener(listener);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.widgets.internal.uploadkit.IUploadAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.uploadLCAAdapter == null) {
                this.uploadLCAAdapter = new UploadLCAAdapter();
            }
            result = this.uploadLCAAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point browseButtonSize = this.computeBrowseButtonSize();
        int browseButtonHeight = browseButtonSize.y;
        int progressHeight = 20;
        int height = 0;
        int width = 0;
        if (wHint == -1 || hHint == -1) {
            if ((this.flags & 1) > 0 && (this.flags & 2) > 0) {
                width = this.computeBaseWidth();
                Point textExtent = Graphics.stringExtent((Font)this.getFont(), (String)this.getUploadButtonText());
                width += textExtent.x;
                height = Math.max(this.computeBaseHeight(), Math.max(textExtent.y, browseButtonHeight));
                height += progressHeight;
            } else if ((this.flags & 1) > 0) {
                width = this.computeBaseWidth();
                height = Math.max(this.computeBaseHeight(), browseButtonHeight);
                height += progressHeight;
            } else if ((this.flags & 2) > 0) {
                width = this.computeBaseWidth();
                Point textExtent = Graphics.stringExtent((Font)this.getFont(), (String)this.getUploadButtonText());
                width += textExtent.x;
                height = Math.max(this.computeBaseHeight(), Math.max(textExtent.y, browseButtonHeight));
            } else {
                width = this.computeBaseWidth();
                height = Math.max(this.computeBaseHeight(), browseButtonHeight);
            }
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height + 2);
    }

    private int computeBaseHeight() {
        return Graphics.getCharHeight((Font)this.getFont());
    }

    private Point computeBrowseButtonSize() {
        int border = this.getButtonBorder();
        int width = 0;
        int height = 0;
        Point extent = Graphics.stringExtent((Font)this.getFont(), (String)this.getBrowseButtonText());
        height = Math.max(height, extent.y);
        width += extent.x;
        width += 12;
        height += 10;
        return new Point(width += border * 2, height += border * 2);
    }

    private int getButtonBorder() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        UploadThemeAdapter themeAdapter = (UploadThemeAdapter)((Object)this.getAdapter(clazz));
        return themeAdapter.getButtonBorderWidth(this);
    }

    private int computeBaseWidth() {
        float avgCharWidth = Graphics.getAvgCharWidth((Font)this.getFont());
        return (int)(avgCharWidth * 50.0f);
    }

    public void setBrowseButtonText(String browseButtonText) {
        this.checkWidget();
        if (browseButtonText == null) {
            SWT.error((int)4);
        }
        this.browseButtonText = browseButtonText;
    }

    public String getBrowseButtonText() {
        this.checkWidget();
        return this.browseButtonText;
    }

    public void setUploadButtonText(String uploadButtonText) {
        this.checkWidget();
        if (uploadButtonText == null) {
            SWT.error((int)4);
        }
        this.uploadButtonText = uploadButtonText;
    }

    public String getUploadButtonText() {
        this.checkWidget();
        return this.uploadButtonText;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.addListener((Adaptable)this, (ModifyListener)listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.removeListener((Adaptable)this, (ModifyListener)listener);
    }

    public String getLastFileUploaded() {
        this.checkWidget();
        return this.lastFileUploaded;
    }

    public File getLastUploadedFile() {
        this.checkWidget();
        return null;
    }

    public UploadItem getUploadItem() {
        this.checkWidget();
        if (this.isDisposed()) {
            SWT.error((int)24);
        }
        FileUploadStorageItem uploadedFile = this.getUploadStorageItem();
        UploadItem uploadItem = new UploadItem(uploadedFile.getFileInputStream(), uploadedFile.getContentType(), this.getLastFileUploaded(), this.getPath(), uploadedFile.getContentLength());
        return uploadItem;
    }

    private String getWidgetId() {
        return String.valueOf(((Object)((Object)this)).hashCode());
    }

    public void setLastFileUploaded(String lastFileUploaded) {
        this.checkWidget();
        this.lastFileUploaded = lastFileUploaded;
    }

    public void addUploadListener(UploadListener listener) {
        this.checkWidget();
        UploadEvent.addListener((Adaptable)this, listener);
    }

    public void removeUploadListener(UploadListener listener) {
        this.checkWidget();
        UploadEvent.removeListener((Adaptable)this, listener);
    }

    public void dispose() {
        FileUploadStorage.getInstance().setUploadStorageItem(this.getWidgetId(), null);
        super.dispose();
    }

    public void reset() {
        this.checkWidget();
        this.lastFileUploaded = "";
        this.path = "";
        this.resetStorageItem();
        this.resetUpload = true;
    }

    private void resetStorageItem() {
        FileUploadStorageItem storageItem = FileUploadStorage.getInstance().getUploadStorageItem(this.getWidgetId());
        storageItem.reset();
    }

    public IUploadConfiguration getConfiguration() {
        return FileUploadServiceHandler.getConfiguration();
    }

    protected FileUploadStorageItem getUploadStorageItem() {
        FileUploadStorage storage = FileUploadStorage.getInstance();
        FileUploadStorageItem uploadedFile = storage.getUploadStorageItem(this.getWidgetId());
        return uploadedFile;
    }

    private final class UploadLCAAdapter
    implements IUploadAdapter {
        private UploadLCAAdapter() {
        }

        public boolean performUpload() {
            boolean result = Upload.this.performUpload;
            Upload.this.performUpload = false;
            return result;
        }

        public int getFlags() {
            return Upload.this.flags;
        }

        public void setPath(String path) {
            if (path != null && !path.equals(Upload.this.path)) {
                Upload.this.path = path;
                ModifyEvent modifyEvent = new ModifyEvent((Control)Upload.this);
                modifyEvent.processEvent();
            }
        }

        public void setLastFileUploaded(String lastFileUploaded) {
            Upload.this.lastFileUploaded = lastFileUploaded;
        }

        public String getServletPath() {
            return Upload.this.servlet;
        }

        public boolean isResetUpload() {
            return Upload.this.resetUpload;
        }

        public void setResetUpload(boolean resetUpload) {
            Upload.this.resetUpload = resetUpload;
        }

        public long getBytesRead() {
            FileUploadStorageItem uploadStorageItem = FileUploadStorage.getInstance().getUploadStorageItem(Upload.this.getWidgetId());
            return uploadStorageItem != null ? uploadStorageItem.getBytesRead() : 0L;
        }

        public FileUploadStorageItem getStorageItem() {
            return Upload.this.getUploadStorageItem();
        }

        public long getContentLength() {
            FileUploadStorageItem uploadStorageItem = FileUploadStorage.getInstance().getUploadStorageItem(Upload.this.getWidgetId());
            return uploadStorageItem != null ? uploadStorageItem.getContentLength() : 0L;
        }
    }
}

