/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.httpservice;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.gyrex.http.application.context.IApplicationContext;
import org.eclipse.gyrex.http.application.context.NamespaceException;
import org.eclipse.gyrex.http.internal.HttpDebug;
import org.eclipse.gyrex.http.internal.httpservice.DefaultHttpContext;
import org.eclipse.gyrex.http.internal.httpservice.DefaultResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceImpl
implements HttpService,
ExtendedHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceImpl.class);
    private final IApplicationContext context;
    private final Bundle bundle;
    private final CopyOnWriteArraySet<String> aliasRegistrations = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<Filter> filterRegistrations = new CopyOnWriteArraySet();

    public HttpServiceImpl(IApplicationContext context, Bundle bundle) {
        this.context = context;
        this.bundle = bundle;
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }

    public IApplicationContext getContext() {
        return this.context;
    }

    public void registerFilter(String alias, Filter filter, Dictionary initparams, HttpContext context) throws ServletException, org.osgi.service.http.NamespaceException {
        if (HttpDebug.httpService) {
            LOG.debug("Registering filter with alias {} (bundle {} ({}), filter {})", new Object[]{alias, this.bundle.getSymbolicName(), this.bundle.getBundleId(), filter});
        }
        this.getContext().registerFilter(alias, filter, this.toMap(initparams));
        this.filterRegistrations.add(filter);
    }

    public void registerResources(String alias, String name, HttpContext context) throws org.osgi.service.http.NamespaceException {
        try {
            if (HttpDebug.httpService) {
                LOG.debug("Registering resource with alias {} (bundle {} ({}), name {})", new Object[]{alias, this.bundle.getSymbolicName(), this.bundle.getBundleId(), name});
            }
            this.getContext().registerResources(alias, name, new DefaultResourceProvider(this.bundle, context));
            this.aliasRegistrations.add(alias);
        }
        catch (NamespaceException e) {
            throw new org.osgi.service.http.NamespaceException(alias, (Throwable)((Object)e));
        }
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext context) throws ServletException, org.osgi.service.http.NamespaceException {
        try {
            if (HttpDebug.httpService) {
                LOG.debug("Registering servlet with alias {} (bundle {} ({}), servlet {})", new Object[]{alias, this.bundle.getSymbolicName(), this.bundle.getBundleId(), servlet});
            }
            this.getContext().registerServlet(alias, servlet, this.toMap(initparams));
            this.aliasRegistrations.add(alias);
        }
        catch (NamespaceException e) {
            throw new org.osgi.service.http.NamespaceException(alias, (Throwable)((Object)e));
        }
    }

    private Map<String, String> toMap(Dictionary initparams) {
        if (initparams == null) {
            return null;
        }
        HashMap<String, String> initparamsMap = new HashMap<String, String>(initparams.size());
        Enumeration keys = initparams.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            try {
                initparamsMap.put((String)key, (String)initparams.get(key));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("invalid key in init properties; only string key and string value supported; key: " + key, e);
            }
        }
        return initparamsMap;
    }

    public void unregister(String alias) {
        if (HttpDebug.httpService) {
            LOG.debug("Unregistering alias {} (bundle {} ({}))", new Object[]{alias, this.bundle.getSymbolicName(), this.bundle.getBundleId()});
        }
        this.getContext().unregister(alias);
        this.aliasRegistrations.remove(alias);
    }

    public void unregisterAll() {
        if (HttpDebug.httpService) {
            LOG.debug("Unregistering all known registrations for bundle {} ({})", new Object[]{this.bundle.getSymbolicName(), this.bundle.getBundleId()});
        }
        for (Filter filter : this.filterRegistrations) {
            try {
                this.unregisterFilter(filter);
            }
            catch (Exception exception) {}
        }
        for (String alias : this.aliasRegistrations) {
            try {
                this.unregister(alias);
            }
            catch (Exception exception) {}
        }
    }

    public void unregisterFilter(Filter filter) {
        if (HttpDebug.httpService) {
            LOG.debug("Unregistering filter (bundle {} ({}), filter {})", new Object[]{this.bundle.getSymbolicName(), this.bundle.getBundleId(), filter});
        }
        this.getContext().unregister(filter);
        this.filterRegistrations.remove(filter);
    }
}

