/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.gyrex.admin.ui.internal.AdminUiHttpServiceTracker;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUiActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.admin.ui";
    public static final int DEFAULT_ADMIN_PORT = 3110;
    public static final String TYPE_ADMIN = "org.eclipse.gyrex.admin.ui.http";
    private static final Logger LOG = LoggerFactory.getLogger(AdminUiActivator.class);
    private static volatile AdminUiActivator instance;
    private AdminUiHttpServiceTracker adminUiHttpServiceTracker;
    public static final String ID_TABBED_PROPERTIES_CONFIG = "org.eclipse.gyrex.admin.ui.content.properties";

    public static ImageDescriptor getImageDescriptor(String path) {
        URL entry = instance.getBundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)entry);
        return descriptor;
    }

    public static AdminUiActivator getInstance() {
        AdminUiActivator activator = instance;
        if (activator == null) {
            throw new IllegalStateException("inactive");
        }
        return activator;
    }

    public AdminUiActivator() {
        super(SYMBOLIC_NAME);
    }

    private Dictionary createAdminSettings(BundleContext context) {
        Hashtable<String, Object> settings = new Hashtable<String, Object>(4);
        ((Dictionary)settings).put("other.info", TYPE_ADMIN);
        ((Dictionary)settings).put("http.enabled", Boolean.TRUE);
        int adminHttpPort = NumberUtils.toInt((String)context.getProperty("gyrex.admin.http.port"), (int)0);
        ((Dictionary)settings).put("http.port", adminHttpPort > 0 && adminHttpPort < 65535 ? adminHttpPort : 3110);
        return settings;
    }

    protected void doStart(final BundleContext context) throws Exception {
        instance = this;
        this.adminUiHttpServiceTracker = new AdminUiHttpServiceTracker(context);
        this.adminUiHttpServiceTracker.open();
        new Job("Start Jetty Admin Server"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    JettyConfigurator.startServer((String)"admin", (Dictionary)AdminUiActivator.this.createAdminSettings(context));
                }
                catch (Exception e) {
                    LOG.error("Failed to start Jetty Admin server.", (Throwable)e);
                    ServerApplication.shutdown((Throwable)new IllegalStateException("Unable to start Jetty admin server.", e));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule(100L);
    }

    protected void doStop(BundleContext context) throws Exception {
        instance = null;
        this.adminUiHttpServiceTracker.close();
        this.adminUiHttpServiceTracker = null;
    }
}

