/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.configuration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.configuration.ConfigurationPage;
import org.eclipse.gyrex.admin.ui.configuration.IConfigurationPageContainer;
import org.eclipse.gyrex.admin.ui.internal.configuration.ConfigurationNavigatorView;
import org.eclipse.gyrex.admin.ui.internal.configuration.ConfigurationPageRegistration;
import org.eclipse.gyrex.admin.ui.internal.configuration.ConfigurationPageSaveable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.part.ViewPart;

public class ConfigurationPanelView
extends ViewPart
implements ISelectionListener,
IConfigurationPageContainer,
ISaveablesSource,
ISaveablePart {
    private static final Saveable[] NO_SAVEABLES = new Saveable[0];
    static final String EMPTY_STRING = "";
    public static final String ID = "org.eclipse.gyrex.admin.ui.view.content";
    private static final String REGISTRATION = "org.eclipse.gyrex.admin.ui.internal.configuration.page.registration";
    private FormToolkit toolkit;
    private ConfigurationPage currentPage;
    private HeaderForm headerForm;
    private ScrolledPageBook pageBook;
    private final Map<String, ConfigurationPage> pagesById = new HashMap<String, ConfigurationPage>();
    private final IPropertyListener pagePropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 257: {
                    if (!(source instanceof ConfigurationPage)) break;
                    ConfigurationPanelView.this.maybeDirty((ConfigurationPage)((Object)source));
                    ConfigurationPanelView.this.updateSaveActions();
                    break;
                }
                case 1: {
                    ConfigurationPanelView.this.updateHeader();
                }
            }
        }
    };
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private final ConcurrentMap<ConfigurationPage, ConfigurationPageSaveable> saveablesByPage = new ConcurrentHashMap<ConfigurationPage, ConfigurationPageSaveable>(4);

    private synchronized void addPage(String id, ConfigurationPageRegistration provider) {
        if (this.pagesById.containsKey(id)) {
            return;
        }
        try {
            ConfigurationPage page = provider.createPage();
            this.pagesById.put(id, page);
            page.setContainer(this);
            Composite pageParent = this.pageBook.createPage((Object)id);
            pageParent.setLayout((Layout)new FillLayout());
            page.createPage(pageParent, this.getToolkit());
            page.getControl().setData(REGISTRATION, (Object)provider);
        }
        catch (CoreException e) {
            Policy.getStatusHandler().show(e.getStatus(), "Error");
        }
        catch (Exception e) {
            e.printStackTrace();
            Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui", "Error loading page " + id, (Throwable)e), "Error");
        }
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        parent.setLayout((Layout)new FillLayout());
        ScrolledForm scform = this.toolkit.createScrolledForm(parent);
        scform.getForm().setData("__ignore_body__", (Object)Boolean.TRUE);
        this.saveAction = ActionFactory.SAVE.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        this.saveAllAction = ActionFactory.SAVE_ALL.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        scform.getToolBarManager().add((IAction)this.saveAction);
        scform.getToolBarManager().add((IAction)this.saveAllAction);
        scform.updateToolBar();
        this.headerForm = new HeaderForm(this, scform);
        this.toolkit.decorateFormHeading(scform.getForm());
        Composite formBody = this.headerForm.getForm().getBody();
        formBody.setLayout((Layout)new FillLayout());
        this.pageBook = this.toolkit.createPageBook(formBody, 16);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
        Collection<ConfigurationPage> pages = this.pagesById.values();
        this.pagesById.clear();
        for (ConfigurationPage page : pages) {
            page.dispose();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("no save on part");
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("no save as on part");
    }

    @Override
    public ConfigurationPage getActivePageInstance() {
        return this.currentPage;
    }

    public Saveable[] getActiveSaveables() {
        if (this.currentPage != null && this.currentPage.isDirty()) {
            return new Saveable[]{new ConfigurationPageSaveable(this, this.currentPage)};
        }
        return NO_SAVEABLES;
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    public Saveable[] getSaveables() {
        Collection saveables = this.saveablesByPage.values();
        return saveables.toArray(new ConfigurationPageSaveable[saveables.size()]);
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public boolean isDirty() {
        return !this.saveablesByPage.isEmpty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    void maybeDirty(ConfigurationPage source) {
        if (source.isDirty()) {
            ConfigurationPageSaveable newSaveable = new ConfigurationPageSaveable(this, source);
            ConfigurationPageSaveable existingSaveable = this.saveablesByPage.putIfAbsent(source, newSaveable);
            ISaveablesLifecycleListener listener = (ISaveablesLifecycleListener)this.getSite().getAdapter(ISaveablesLifecycleListener.class);
            if (listener != null) {
                SaveablesLifecycleEvent event = existingSaveable == null ? new SaveablesLifecycleEvent((Object)this, 1, new Saveable[]{newSaveable}, false) : new SaveablesLifecycleEvent((Object)this, 4, new Saveable[]{existingSaveable}, false);
                listener.handleLifecycleEvent(event);
            }
        } else {
            ConfigurationPageSaveable saveable = (ConfigurationPageSaveable)((Object)this.saveablesByPage.remove((Object)source));
            ISaveablesLifecycleListener listener = (ISaveablesLifecycleListener)this.getSite().getAdapter(ISaveablesLifecycleListener.class);
            if (listener != null && saveable != null) {
                listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 3, new Saveable[]{saveable}, false));
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(part instanceof ConfigurationNavigatorView)) {
            return;
        }
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object firstElement = ((StructuredSelection)selection).getFirstElement();
        if (firstElement instanceof ConfigurationPageRegistration) {
            ConfigurationPageRegistration provider = (ConfigurationPageRegistration)firstElement;
            String id = provider.getId();
            if (!this.pagesById.containsKey(id)) {
                this.addPage(id, provider);
            }
            this.showPage(id);
        }
    }

    void setBusy(boolean busy) {
        this.headerForm.getForm().setBusy(busy);
    }

    public void setFocus() {
        this.pageBook.setFocus();
    }

    private void showPage(String id) {
        if (this.currentPage != null) {
            this.currentPage.setActive(false);
            this.currentPage.removePropertyListener(this.pagePropertyListener);
            this.currentPage = null;
        }
        this.currentPage = this.pagesById.get(id);
        this.pageBook.showPage((Object)id);
        this.updateHeader();
        this.updateSaveActions();
        this.getSite().setSelectionProvider(this.currentPage.getSelectionProvider());
        if (this.currentPage != null) {
            this.currentPage.addPropertyListener(this.pagePropertyListener);
            this.currentPage.setActive(true);
        }
    }

    void updateHeader() {
        ConfigurationPage page = this.getActivePageInstance();
        if (page != null) {
            this.headerForm.getForm().setImage(page.getTitleImage());
            String title = page.getTitle();
            if (StringUtils.isEmpty((String)title)) {
                ConfigurationPageRegistration registration = (ConfigurationPageRegistration)page.getControl().getData(REGISTRATION);
                title = registration.getName();
            }
            this.headerForm.getForm().setText(title);
            this.headerForm.getForm().getForm().getHead().setToolTipText(page.getTitleToolTip());
            this.setTitleToolTip(page.getTitleToolTip());
            this.setContentDescription(title);
        } else {
            this.headerForm.getForm().setImage(null);
            this.headerForm.getForm().setText(EMPTY_STRING);
            this.headerForm.getForm().getForm().getHead().setToolTipText(EMPTY_STRING);
            this.setTitleToolTip(EMPTY_STRING);
            this.setContentDescription(EMPTY_STRING);
        }
    }

    void updateSaveActions() {
        this.saveAction.setEnabled(this.currentPage != null && this.currentPage.isDirty());
        this.saveAllAction.setEnabled(this.isDirty());
    }

    private static class HeaderForm
    extends ManagedForm {
        public HeaderForm(ConfigurationPanelView configurationPanelView, ScrolledForm form) {
            super(configurationPanelView.getToolkit(), form);
            this.setContainer(configurationPanelView);
        }

        public void dirtyStateChanged() {
            this.getView().firePropertyChange(257);
        }

        private ConfigurationPanelView getView() {
            return (ConfigurationPanelView)this.getContainer();
        }

        public void staleStateChanged() {
            this.refresh();
        }
    }
}

