/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.PurgeTxnLog;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateApplication;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperServerConfig;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.eclipse.gyrex.server.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerApplication
extends BaseApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerApplication.class);
    static volatile ZooKeeperGateApplication connectedGateApplication;
    private NIOServerCnxn.Factory factory;
    private QuorumPeer quorumPeer;
    private ZooKeeperServer zkServer;

    public ZooKeeperServerApplication() {
        this.debug = CloudDebug.zooKeeperServer;
    }

    protected void doStart(Map arguments) throws Exception {
        ZooKeeperServerConfig config = new ZooKeeperServerConfig();
        File zkConfigFile = Platform.getInstanceLocation().append("etc/zookeeper.properties").toFile();
        if (zkConfigFile.isFile() && zkConfigFile.canRead()) {
            String zkConfigFilePath = zkConfigFile.getAbsolutePath();
            LOG.warn("Running ZooKeeper with external configuration: {}", (Object)zkConfigFilePath);
            try {
                config.parse(zkConfigFilePath);
            }
            catch (QuorumPeerConfig.ConfigException e) {
                LOG.error("Error in ZooKeeper configuration (file {}). {}", (Object)zkConfigFilePath, (Object)e.getMessage());
                throw e;
            }
        } else {
            if (CloudDebug.zooKeeperServer) {
                LOG.debug("Running with managed ZooKeeper configuration.");
            }
            config.readFromPreferences();
        }
        if (config.getServers().size() > 1) {
            this.runEnsemble(config);
        } else {
            this.runStandalone(config);
        }
    }

    protected Object doStop() {
        ZooKeeperGateApplication gateApp = connectedGateApplication;
        if (gateApp != null) {
            connectedGateApplication = null;
            try {
                gateApp.stop();
            }
            catch (Exception exception) {}
        }
        try {
            if (CloudDebug.zooKeeperServer) {
                LOG.debug("Preparing for ZooKeeper shutdown...");
            }
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        if (this.factory != null) {
            if (CloudDebug.zooKeeperServer) {
                LOG.debug("Shutting down standalone ZooKeeper server...");
            }
            this.factory.shutdown();
            this.factory = null;
            if (this.zkServer.isRunning()) {
                this.zkServer.shutdown();
            }
            this.zkServer = null;
            LOG.info("ZooKeeper server stopped.");
        }
        if (this.quorumPeer != null) {
            if (CloudDebug.zooKeeperServer) {
                LOG.debug("Shutting down ensemble node...");
            }
            this.quorumPeer.shutdown();
            this.quorumPeer = null;
            LOG.info("ZooKeeper ensemble node stopped.");
        }
        return EXIT_OK;
    }

    protected Logger getLogger() {
        return LOG;
    }

    private void runEnsemble(ZooKeeperServerConfig config) throws IOException {
        if (config.isPreferencesBased()) {
            throw new IllegalArgumentException("Please create a ZooKeeper configuration file in order to setup an ensamble.");
        }
        File dataDir = new File(config.getDataLogDir());
        File snapDir = new File(config.getDataDir());
        PurgeTxnLog.purge((File)dataDir, (File)snapDir, (int)3);
        NIOServerCnxn.Factory cnxnFactory = new NIOServerCnxn.Factory(config.getClientPortAddress(), config.getMaxClientCnxns());
        this.quorumPeer = new QuorumPeer();
        this.quorumPeer.setClientPortAddress(config.getClientPortAddress());
        this.quorumPeer.setTxnFactory(new FileTxnSnapLog(dataDir, snapDir));
        this.quorumPeer.setQuorumPeers(config.getServers());
        this.quorumPeer.setElectionType(config.getElectionAlg());
        this.quorumPeer.setMyid(config.getServerId());
        this.quorumPeer.setTickTime(config.getTickTime());
        this.quorumPeer.setMinSessionTimeout(config.getMinSessionTimeout());
        this.quorumPeer.setMaxSessionTimeout(config.getMaxSessionTimeout());
        this.quorumPeer.setInitLimit(config.getInitLimit());
        this.quorumPeer.setSyncLimit(config.getSyncLimit());
        this.quorumPeer.setQuorumVerifier(config.getQuorumVerifier());
        this.quorumPeer.setCnxnFactory(cnxnFactory);
        this.quorumPeer.setZKDatabase(new ZKDatabase(this.quorumPeer.getTxnFactory()));
        this.quorumPeer.setLearnerType(config.getPeerType());
        LOG.info("Starting ZooKeeper ensemble node.");
        this.quorumPeer.start();
    }

    private void runStandalone(ZooKeeperServerConfig config) throws IOException {
        System.setProperty("zookeeper.jmx.log4j.disable", Boolean.TRUE.toString());
        File dataDir = new File(config.getDataLogDir());
        File snapDir = new File(config.getDataDir());
        PurgeTxnLog.purge((File)dataDir, (File)snapDir, (int)3);
        this.zkServer = new ZooKeeperServer();
        this.zkServer.setTxnLogFactory(new FileTxnSnapLog(dataDir, snapDir));
        this.zkServer.setTickTime(config.getTickTime());
        this.zkServer.setMinSessionTimeout(config.getMinSessionTimeout());
        this.zkServer.setMaxSessionTimeout(config.getMaxSessionTimeout());
        this.factory = new NIOServerCnxn.Factory(config.getClientPortAddress(), config.getMaxClientCnxns());
        LOG.info("Starting ZooKeeper standalone server.");
        try {
            this.factory.startup(this.zkServer);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted during server start.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

