/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.jetty.internal;

import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.AddChannelDialog;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.JettyConfigurationPage;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class ChannelsSection
extends ViewerWithButtonsSectionPart {
    private Button addButton;
    private Button removeButton;
    private ListViewer channelsList;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedChannelValue;

    public ChannelsSection(Composite parent, JettyConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Connectors");
        section.setDescription("Configure the HTTP connectors that should be available for handling requests.");
        this.createContent(section);
    }

    void addButtonPressed() {
        AddChannelDialog dialog = new AddChannelDialog(SwtUtil.getShell((Widget)this.addButton), this.getJettyManager());
        if (dialog.open() == 0) {
            this.markStale();
        }
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelsSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelsSection.this.removeButtonPressed();
            }
        });
    }

    protected void createViewer(Composite client) {
        this.channelsList = new ListViewer(client, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.channelsList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.channelsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.channelsList.setLabelProvider((IBaseLabelProvider)new ChannelsLabelProvider());
        this.selectedChannelValue = ViewersObservables.observeSingleSelection((Viewer)this.channelsList);
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    private IJettyManager getJettyManager() {
        return (IJettyManager)this.getManagedForm().getInput();
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeButton), (IObservableValue)SWTObservables.observeSelection((Control)this.channelsList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        Object input = this.getManagedForm().getInput();
        if (input instanceof IJettyManager) {
            IJettyManager jettyManager = (IJettyManager)input;
            Collection channels = jettyManager.getChannels();
            this.channelsList.setInput((Object)channels);
        }
        super.refresh();
    }

    void removeButtonPressed() {
        ChannelDescriptor channel = (ChannelDescriptor)(this.selectedChannelValue != null ? this.selectedChannelValue.getValue() : null);
        if (channel == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Remove Channel", (String)"Do you really want to delete the channel?")) {
            return;
        }
        this.getJettyManager().removeChannel(channel.getId());
        this.markStale();
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IJettyManager) {
            this.markStale();
            return true;
        }
        return super.setFormInput(input);
    }

    static class ChannelsLabelProvider
    extends LabelProvider {
        ChannelsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ChannelDescriptor) {
                ChannelDescriptor channel = (ChannelDescriptor)element;
                return String.format("%s (%d)", channel.getId(), channel.getPort());
            }
            return super.getText(element);
        }
    }
}

