/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.app;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.Interpreter;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.nio.charset.Charset;
import java.util.logging.LogManager;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.boot.internal.app.AppActivator;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.slf4j.LoggerFactory;

public class LogbackConfigurator {
    public static void configureDefaultContext(String[] arguments) throws Exception {
        LogManager.getLogManager().reset();
        if (StringUtils.isNotBlank((String)System.getProperty("logback.configurationFile"))) {
            return;
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
        StatusManager sm = lc.getStatusManager();
        if (sm != null) {
            sm.add((Status)new InfoStatus("Setting up Gyrex log configuration.", (Object)lc));
        }
        final IPath instanceLogfileDirectory = LogbackConfigurator.getLogfileDir();
        instanceLogfileDirectory.toFile().mkdirs();
        File configurationFile = LogbackConfigurator.getLogConfigurationFile();
        if (configurationFile.exists() && configurationFile.isFile() && configurationFile.canRead()) {
            sm.add((Status)new InfoStatus("Loading configuration from workspace.", (Object)lc));
            JoranConfigurator configurator = new JoranConfigurator(){

                protected void addImplicitRules(Interpreter interpreter) {
                    super.addImplicitRules(interpreter);
                    interpreter.getInterpretationContext().addSubstitutionProperty("gyrex.instance.area.logs", instanceLogfileDirectory.addTrailingSeparator().toOSString());
                }
            };
            configurator.setContext((Context)lc);
            configurator.doConfigure(configurationFile);
            StatusPrinter.printIfErrorsOccured((Context)lc);
            return;
        }
        Logger rootLogger = lc.getLogger("ROOT");
        LevelChangePropagator levelChangePropagator = new LevelChangePropagator();
        levelChangePropagator.setResetJUL(true);
        levelChangePropagator.setContext((Context)lc);
        lc.addListener((LoggerContextListener)levelChangePropagator);
        levelChangePropagator.start();
        if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
            ConsoleAppender ca = new ConsoleAppender();
            ca.setContext((Context)lc);
            ca.setName("console");
            PatternLayoutEncoder pl = new PatternLayoutEncoder();
            pl.setContext((Context)lc);
            pl.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
            pl.start();
            ca.setEncoder((Encoder)pl);
            ca.start();
            rootLogger.addAppender((Appender)ca);
        } else {
            rootLogger.setLevel(Level.INFO);
        }
        lc.getLogger("org.apache.commons.httpclient").setLevel(Level.WARN);
        lc.getLogger("httpclient.wire").setLevel(Level.WARN);
        lc.getLogger("org.apache.http").setLevel(Level.WARN);
        lc.getLogger("org.apache.zookeeper").setLevel(Level.WARN);
        lc.getLogger("org.apache.solr").setLevel(Level.WARN);
        lc.getLogger("org.mortbay.log").setLevel(Level.INFO);
        lc.getLogger("org.eclipse.jetty").setLevel(Level.INFO);
        lc.getLogger("org.quartz").setLevel(Level.INFO);
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext((Context)lc);
        rfa.setName("error-log");
        rfa.setFile(instanceLogfileDirectory.append("error.log").toOSString());
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setMinIndex(1);
        rollingPolicy.setMaxIndex(3);
        rollingPolicy.setFileNamePattern("error.%i.log.zip");
        rollingPolicy.setParent((FileAppender)rfa);
        rfa.setRollingPolicy((RollingPolicy)rollingPolicy);
        rfa.setTriggeringPolicy((TriggeringPolicy)new SizeBasedTriggeringPolicy("5MB"));
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext((Context)lc);
        pl.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
        pl.setCharset(Charset.forName("UTF-8"));
        pl.start();
        rfa.setEncoder((Encoder)pl);
        ThresholdFilter tf = new ThresholdFilter();
        tf.setContext((Context)lc);
        tf.setLevel(Level.ERROR.toString());
        tf.start();
        rfa.addFilter((Filter)tf);
        rfa.start();
        rootLogger.addAppender((Appender)rfa);
        StatusPrinter.printIfErrorsOccured((Context)lc);
    }

    private static File getLogConfigurationFile() {
        Location instanceLocation = AppActivator.getInstance().getInstanceLocation();
        return new Path(instanceLocation.getURL().getPath()).append("etc/logback.xml").toFile();
    }

    private static IPath getLogfileDir() {
        Location instanceLocation = AppActivator.getInstance().getInstanceLocation();
        return new Path(instanceLocation.getURL().getPath()).append("logs");
    }

    public static void reset() throws Exception {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
        StatusPrinter.printIfErrorsOccured((Context)lc);
    }
}

