/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.kohsuke.args4j.Argument;

public abstract class BaseScheduleStoreCmd
extends Command {
    @Argument(index=0, usage="specify the schedule storage key", required=true, metaVar="SCHEDULE")
    protected String scheduleStorageKey;

    public BaseScheduleStoreCmd(String description) {
        super("<scheduleStorageKey> " + description);
    }

    protected void doExecute() throws Exception {
        if (!IdHelper.isValidId((String)this.scheduleStorageKey)) {
            throw new IllegalArgumentException("invalid storage key");
        }
        String externalId = ScheduleManagerImpl.getExternalId(this.scheduleStorageKey);
        this.doExecute(this.scheduleStorageKey, externalId);
    }

    protected abstract void doExecute(String var1, String var2) throws Exception;
}

