/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryStore;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CleanupJob
extends Job {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupJob.class);
    private static final long MAX_JOB_AGE = TimeUnit.DAYS.toMillis(2L);

    public CleanupJob() {
        super("Gyrex Job API Garbage Collector");
        this.setSystem(true);
        this.setPriority(30);
        this.setRule(new MutexRule(CleanupJob.class));
    }

    protected IStatus run(IProgressMonitor monitor) {
        IEclipsePreferences jobsNode = JobHistoryStore.getJobsNode();
        try {
            String[] childrenNames;
            LOG.info("Cleaning up of old job definitions.");
            long now = System.currentTimeMillis();
            String[] stringArray = childrenNames = jobsNode.childrenNames();
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                String externalId = JobManagerImpl.getExternalId(internalId);
                JobImpl job = JobManagerImpl.readJob(externalId, jobsNode.node(internalId));
                if (job.getState() == JobState.NONE && now - job.getLastResultTimestamp() >= MAX_JOB_AGE) {
                    LOG.info("Removing job {}.", (Object)externalId);
                    if (jobsNode.nodeExists(internalId)) {
                        jobsNode.node(internalId).removeNode();
                        jobsNode.flush();
                    }
                    IEclipsePreferences statesNode = JobManagerImpl.getStatesNode();
                    JobState[] jobStateArray = JobState.values();
                    int n3 = jobStateArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        JobState state = jobStateArray[n4];
                        Preferences stateNode = statesNode.node(state.name());
                        if (stateNode.get(internalId, null) != null) {
                            stateNode.remove(internalId);
                            stateNode.flush();
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            LOG.info("Finished clean-up of old job definitions.");
        }
        catch (BackingStoreException e) {
            LOG.warn("Unable to clean-up old job definitions. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    static class MutexRule
    implements ISchedulingRule {
        private final Object object;

        public MutexRule(Object object) {
            this.object = object;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof MutexRule) {
                return this.object.equals(((MutexRule)rule).object);
            }
            return false;
        }
    }
}

