/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.jobs.history.IJobHistory;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryItemImpl;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

final class JobHistoryImpl
implements IJobHistory {
    private static final String KEY_RESULT_SEVERITY = "resultSeverity";
    private static final String KEY_RESULT_MESSAGE = "resultMessage";
    private static final String KEY_TIMESTAMP = "timestamp";
    private final String jobId;
    private final IPath contextPath;
    private List<IJobHistoryEntry> entries;

    public JobHistoryImpl(String jobId, IPath contextPath) {
        this.jobId = jobId;
        this.contextPath = contextPath;
    }

    public void createEntry(long resultTimestamp, String message, int severity) {
        this.entries.add(new JobHistoryItemImpl(resultTimestamp, message, severity));
    }

    public IPath getContextPath() {
        return this.contextPath;
    }

    @Override
    public List<IJobHistoryEntry> getEntries() {
        if (this.entries == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.entries);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void load(IEclipsePreferences historyNode) throws BackingStoreException {
        String[] childrenNames = historyNode.childrenNames();
        this.entries = new ArrayList<IJobHistoryEntry>(childrenNames.length);
        String[] stringArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String entryId = stringArray[n2];
            Preferences node = historyNode.node(entryId);
            long ts = node.getLong(KEY_TIMESTAMP, 0L);
            String message = node.get(KEY_RESULT_MESSAGE, "");
            int severity = node.getInt(KEY_RESULT_SEVERITY, 8);
            this.entries.add(new JobHistoryItemImpl(ts, message, severity));
            ++n2;
        }
    }

    public void save(IEclipsePreferences historyNode) throws BackingStoreException {
        if (this.entries == null) {
            return;
        }
        for (IJobHistoryEntry entry : this.entries) {
            String entryId = String.valueOf(entry.getTimeStamp());
            if (historyNode.nodeExists(entryId)) continue;
            Preferences node = historyNode.node(entryId);
            node.putLong(KEY_TIMESTAMP, entry.getTimeStamp());
            node.put(KEY_RESULT_MESSAGE, entry.getResult());
            node.putInt(KEY_RESULT_SEVERITY, entry.getSeverity());
        }
        historyNode.flush();
    }
}

