/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.worker.WorkerEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerEngineApplication
implements IApplication {
    private static final Integer EXIT_ERROR = 1;
    private static final Logger LOG = LoggerFactory.getLogger(WorkerEngineApplication.class);
    private static final AtomicReference<WorkerEngine> workerEngineRef = new AtomicReference<Object>(null);
    private IApplicationContext runningContext;

    public Object start(IApplicationContext context) throws Exception {
        WorkerEngine workerEngine;
        if (JobsDebug.workerEngine) {
            LOG.debug("Starting worker engine application.");
        }
        if (!workerEngineRef.compareAndSet(null, workerEngine = new WorkerEngine())) {
            throw new IllegalStateException("Worker engine already running!");
        }
        try {
            workerEngine.schedule();
            context.applicationRunning();
            this.runningContext = context;
            return IApplicationContext.EXIT_ASYNC_RESULT;
        }
        catch (Exception e) {
            LOG.error("Unable to start worker engine. Please check the log files.", (Throwable)e);
            return EXIT_ERROR;
        }
    }

    public void stop() {
        IApplicationContext context = this.runningContext;
        if (context == null) {
            throw new IllegalStateException("not started");
        }
        final WorkerEngine engine = workerEngineRef.getAndSet(null);
        if (engine == null) {
            return;
        }
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Stopping scheduler engine application...");
        }
        if (!engine.cancel()) {
            try {
                LOG.info("Waiting for worker engine to finish remaining work...");
                final CountDownLatch wait = new CountDownLatch(1);
                Job job = new Job("Worker Engine Shutdown Job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            try {
                                if (engine.getState() == 4) {
                                    engine.join();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                wait.countDown();
                            }
                        }
                        finally {
                            wait.countDown();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.setPriority(20);
                job.schedule();
                if (!wait.await(30L, TimeUnit.SECONDS)) {
                    LOG.warn("Time out waiting for worker engine to finish remaining work. A complete restart of the process may be required.");
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Starting scheduler engine stopped.");
        }
        context.setResult((Object)EXIT_OK, (IApplication)this);
    }
}

