/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.http.internal.application.gateway.IHttpGateway;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.JettyGateway;
import org.eclipse.gyrex.http.jetty.internal.connectors.CertificateSslContextFactory;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyEngineApplication
implements IApplication {
    private static final Logger LOG = LoggerFactory.getLogger(JettyEngineApplication.class);
    private static final Integer EXIT_ERROR = 1;
    private static final AtomicReference<CountDownLatch> stopSignalRef = new AtomicReference<Object>(null);
    private static final AtomicReference<Throwable> jettyErrorRef = new AtomicReference();

    public static void forceShutdown() {
        CountDownLatch stopSignal = stopSignalRef.get();
        if (stopSignal != null) {
            stopSignal.countDown();
        }
    }

    private void configureServer(Server server) {
        if (JettyDebug.engine) {
            LOG.debug("Configuring server {}", (Object)server);
        }
        Map<String, Object> nodeProperties = this.getNodeProperties();
        IJettyManager jettyManager = HttpJettyActivator.getInstance().getJettyManager();
        Collection<ChannelDescriptor> channels = jettyManager.getChannels();
        if (!channels.isEmpty()) {
            for (ChannelDescriptor channel : channels) {
                this.createConnector(server, channel, jettyManager, nodeProperties);
            }
        } else if (Platform.inDevelopmentMode()) {
            LOG.info("No channels configured. Enabling default channel on port 8080 in development mode.");
            ChannelDescriptor defaultChannel = new ChannelDescriptor();
            defaultChannel.setId("default");
            defaultChannel.setPort(8080);
            this.createConnector(server, defaultChannel, jettyManager, nodeProperties);
        }
        server.setSendServerVersion(true);
        server.setSendDateHeader(true);
        server.setGracefulShutdown(5000);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("jetty-server");
        server.setThreadPool((ThreadPool)threadPool);
    }

    private void createConnector(Server server, ChannelDescriptor channel, IJettyManager jettyManager, Map<String, Object> nodeProperties) {
        if (channel.getPort() <= 0 || channel.getPort() > 65535) {
            if (JettyDebug.engine) {
                LOG.debug("Ignoring disabled channel {}", (Object)channel);
            }
            return;
        }
        try {
            ChannelDescriptor secureChannel;
            SelectChannelConnector connector;
            Filter nodeFilter;
            String filter = channel.getNodeFilter();
            if (filter != null && !(nodeFilter = FrameworkUtil.createFilter((String)filter)).matches(nodeProperties)) {
                if (JettyDebug.engine) {
                    LOG.debug("Ignoring channel {} which has a node filter that does not match this node.", (Object)channel);
                }
                return;
            }
            if (JettyDebug.engine) {
                LOG.debug("Configuring channel {}", (Object)channel);
            }
            if (channel.isSecure()) {
                ICertificate certificate = jettyManager.getCertificate(channel.getCertificateId());
                connector = new SslSelectChannelConnector((SslContextFactory)new CertificateSslContextFactory(certificate));
            } else {
                connector = new SelectChannelConnector();
            }
            connector.setPort(channel.getPort());
            connector.setMaxIdleTime(200000);
            connector.setAcceptors(2);
            connector.setStatsOn(false);
            connector.setLowResourcesConnections(20000);
            connector.setLowResourcesMaxIdleTime(5000);
            connector.setForwarded(true);
            if (channel.getSecureChannelId() != null && (secureChannel = jettyManager.getChannel(channel.getSecureChannelId())) != null) {
                connector.setConfidentialPort(secureChannel.getPort());
                connector.setConfidentialScheme("https");
                connector.setIntegralPort(secureChannel.getPort());
                connector.setIntegralScheme("https");
            }
            server.addConnector((Connector)connector);
        }
        catch (Exception e) {
            LOG.warn("Error configuring channel {}. Please check the channel configuration. {}", (Object)channel.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private Map<String, Object> getNodeProperties() {
        INodeEnvironment nodeEnvironment = HttpJettyActivator.getInstance().getNodeEnvironment();
        HashMap<String, Object> nodeProperties = new HashMap<String, Object>(2);
        nodeProperties.put("id", nodeEnvironment.getNodeId());
        Set tags = nodeEnvironment.getTags();
        if (!tags.isEmpty()) {
            nodeProperties.put("tag", tags.toArray(new String[tags.size()]));
        }
        return nodeProperties;
    }

    boolean isActive() {
        CountDownLatch stopSignal = stopSignalRef.get();
        return stopSignal != null && stopSignal.getCount() > 0L;
    }

    void signalStopped(Throwable jettyError) {
        CountDownLatch signal;
        if (JettyDebug.engine) {
            LOG.debug("Received stop signal for Jetty engine.");
        }
        if ((signal = stopSignalRef.get()) != null) {
            jettyErrorRef.set(jettyError);
            signal.countDown();
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        CountDownLatch stopSignal;
        if (JettyDebug.engine) {
            LOG.debug("Starting Jetty engine.");
        }
        if (!stopSignalRef.compareAndSet(null, stopSignal = new CountDownLatch(1))) {
            throw new IllegalStateException("Jetty engine already running!");
        }
        try {
            Throwable error;
            int timeout = 5000;
            while (timeout > 0) {
                try {
                    CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty");
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    if (!JettyDebug.engine) continue;
                    LOG.debug("Platform preferences not available. Jetty start will be delayed.");
                    try {
                        timeout -= 500;
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            Server server = new Server();
            JettyGateway gateway = new JettyGateway(server);
            this.configureServer(server);
            server.start();
            HttpGenerator.setServerVersion((String)"7");
            if (JettyDebug.engine) {
                LOG.debug("Jetty server started!");
                LOG.debug(server.dump());
            }
            ServiceRegistration gatewayServiceRegistration = HttpJettyActivator.getInstance().getServiceHelper().registerService(IHttpGateway.class.getName(), (Object)gateway, "Eclipse Gyrex", "Jetty based HTTP gateway.", null, null);
            if (JettyDebug.engine) {
                LOG.debug("Jetty HTTP gateway registered!");
                LOG.debug(server.dump());
            }
            context.applicationRunning();
            try {
                stopSignal.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            gatewayServiceRegistration.unregister();
            try {
                server.stop();
            }
            catch (Exception e) {
                if (JettyDebug.debug) {
                    LOG.warn("Error while stopping Jetty. {}", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                }
                LOG.warn("Error while stopping Jetty. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            if (gateway != null) {
                gateway.close();
                gateway = null;
            }
            if (JettyDebug.engine) {
                LOG.debug("Jetty engine shutdown complete.");
            }
            Integer n = (error = (Throwable)jettyErrorRef.getAndSet(null)) == null ? IApplication.EXIT_OK : EXIT_ERROR;
            return n;
        }
        catch (Exception e) {
            LOG.error("Unable to start Jetty. Please check the log files. System will be shutdown.", (Throwable)e);
            Integer n = EXIT_ERROR;
            return n;
        }
        finally {
            stopSignalRef.compareAndSet(stopSignal, null);
        }
    }

    public void stop() {
        this.signalStopped(null);
    }
}

