/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutFactory;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobLog;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsConfigurationPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsLabelProvider;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiActivator;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.history.IJobHistory;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class JobsHistorySection
extends ViewerWithButtonsSectionPart {
    private Button refrehButton;
    private ListViewer dataList;
    private Combo combo;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedValue;

    public JobsHistorySection(Composite parent, JobsConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 512);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("History");
        section.setDescription("View history of recently executed jobs.");
        this.createContent(section);
    }

    protected void createButtons(Composite buttonsPanel) {
        this.refrehButton = this.createButton(buttonsPanel, "Refresh", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobsHistorySection.this.refreshButtonPressed();
            }
        });
    }

    private void createCombo(Composite contentPanel) {
        this.combo = new Combo(contentPanel, 2060);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.add("All registred contexts");
        for (ContextDefinition def : ((ContextRegistryImpl)this.getContextRegistry()).getDefinedContexts()) {
            this.combo.add(def.getPath().toString());
        }
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobsHistorySection.this.setViewerInput();
            }
        });
        this.combo.select(0);
    }

    protected void createContent(Section section) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        Composite client = this.getToolkit().createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        client.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        section.setClient((Control)client);
        this.createContentPanel(client);
        this.createButtonPanel(client);
        this.setViewerInput();
    }

    protected void createContentPanel(Composite parent) {
        Composite contentPanel = this.getToolkit().createComposite(parent);
        contentPanel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        contentPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.createCombo(contentPanel);
        this.createViewer(contentPanel);
    }

    protected void createViewer(final Composite parent) {
        this.dataList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x200);
        org.eclipse.swt.widgets.List list = this.dataList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 250;
        layoutData.grabExcessHorizontalSpace = true;
        list.setLayoutData((Object)layoutData);
        this.dataList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataList.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.dataList);
        this.dataList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (JobsHistorySection.this.selectedValue != null) {
                    JobLog log = (JobLog)JobsHistorySection.this.selectedValue.getValue();
                    String msg = String.format("Message: '%s'\nFinished with error: %s\nFinished with warning: %s", log.getId(), Boolean.toString(log.isError()), Boolean.toString(log.isWarning()));
                    MessageDialog.openInformation((Shell)parent.getShell(), (String)"Running Details", (String)msg);
                }
            }
        });
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    private IRuntimeContextRegistry getContextRegistry() {
        return (IRuntimeContextRegistry)JobsUiActivator.getInstance().getService(IRuntimeContextRegistry.class);
    }

    private List<JobLog> getJobLogs(IRuntimeContext context) {
        IJobManager manager = (IJobManager)context.get(IJobManager.class);
        ArrayList<JobLog> result = new ArrayList<JobLog>();
        for (String jobId : manager.getJobs()) {
            IJobHistory history = manager.getHistory(jobId);
            for (IJobHistoryEntry historyItem : history.getEntries()) {
                String msg = String.format("[%s] %s : %s", DateFormatUtils.format((long)historyItem.getTimeStamp(), (String)"yyyy-MM-dd hh:mm:ssss"), jobId, historyItem.getResult());
                result.add(new JobLog(msg, historyItem.getSeverity() == 4, historyItem.getSeverity() == 8));
            }
        }
        return result;
    }

    JobLog getSelectedValue() {
        return (JobLog)(this.selectedValue != null ? this.selectedValue.getValue() : null);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.refrehButton), (IObservableValue)SWTObservables.observeSelection((Control)this.dataList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        this.setViewerInput();
        super.refresh();
    }

    void refreshButtonPressed() {
        this.refresh();
    }

    private void setViewerInput() {
        ArrayList<JobLog> logs = new ArrayList<JobLog>();
        IRuntimeContextRegistry contextRegistry = this.getContextRegistry();
        if (this.combo.getSelectionIndex() == 0) {
            for (ContextDefinition def : ((ContextRegistryImpl)contextRegistry).getDefinedContexts()) {
                logs.addAll(this.getJobLogs(contextRegistry.get(def.getPath())));
            }
        } else {
            logs.addAll(this.getJobLogs(contextRegistry.get((IPath)new Path(this.combo.getText()))));
        }
        this.dataList.setInput(logs);
    }
}

