/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.tests.internal;

import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.gyrex.preferences.internal.PreferencesDebug;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperPreferencesTests {
    private static final String TESTS = "tests";

    @Before
    public void setUp() throws Exception {
        PreferencesDebug.debug = true;
        CloudDebug.debug = true;
        CloudDebug.zooKeeperPreferences = true;
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testEmptyNodes() throws Exception {
        String testNodeName;
        IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode(TESTS);
        if (rootNode.nodeExists(testNodeName = "testNode" + System.currentTimeMillis())) {
            rootNode.node(testNodeName).removeNode();
            rootNode.flush();
        }
        Assert.assertFalse((String)"test node must not exists after flush", (boolean)rootNode.nodeExists(testNodeName));
        IPath testNodeZkPath = IZooKeeperLayout.PATH_PREFERENCES_ROOT.append("cloud").append(TESTS).append(testNodeName);
        Assert.assertFalse((String)"test node path must not exists in ZooKeeper after flush", (boolean)ZooKeeperGate.get().exists(testNodeZkPath));
        rootNode.node(testNodeName);
        rootNode.flush();
        Assert.assertTrue((String)"test node must exists after flush", (boolean)rootNode.nodeExists(testNodeName));
        Assert.assertTrue((String)"test node path must exists in ZooKeeper after flush", (boolean)ZooKeeperGate.get().exists(testNodeZkPath));
    }
}

