/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.NodeEnvironmentImpl;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.eclipse.gyrex.cloud.internal.NodeMetricsReporter;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperNodeInfo;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.gyrex.server.internal.roles.LocalRolesManager;
import org.eclipse.gyrex.server.internal.roles.ServerRoleDefaultStartOption;
import org.eclipse.gyrex.server.internal.roles.ServerRolesRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudState
implements ZooKeeperGate.IConnectionMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(CloudState.class);
    private static final AtomicReference<CloudState> instanceRef = new AtomicReference();
    private final Lock registrationLock = new ReentrantLock();
    private final AtomicReference<State> state = new AtomicReference<State>(State.DISCONNECTED);
    private final AtomicReference<NodeInfo> myInfo = new AtomicReference();
    private final AtomicReference<List<String>> myRoles = new AtomicReference();
    private final ZooKeeperMonitor monitor = new ZooKeeperMonitor(){

        @Override
        protected void pathCreated(String path) {
            NodeInfo nodeInfo = (NodeInfo)CloudState.this.myInfo.get();
            if (nodeInfo == null) {
                return;
            }
            if (path.equals(IZooKeeperLayout.PATH_NODES_APPROVED.append(nodeInfo.getNodeId()).toString())) {
                this.reconnect(nodeInfo);
            }
        }

        @Override
        protected void pathDeleted(String path) {
            NodeInfo nodeInfo = (NodeInfo)CloudState.this.myInfo.get();
            if (nodeInfo == null) {
                return;
            }
            if (path.equals(IZooKeeperLayout.PATH_NODES_APPROVED.append(nodeInfo.getNodeId()).toString())) {
                this.reconnect(nodeInfo);
            }
        }

        private void reconnect(NodeInfo nodeInfo) {
            block5: {
                try {
                    CloudState.unregisterNode();
                }
                catch (Exception e) {
                    if (!CloudDebug.cloudState) break block5;
                    LOG.debug("Exception unregistering node {}. {}", new Object[]{nodeInfo, e.getMessage(), e});
                }
            }
            try {
                CloudState.registerNode();
            }
            catch (Exception e) {
                if (CloudDebug.debug) {
                    LOG.error("Failed to re-register node. Node {} will not be available in cloud. {}", new Object[]{nodeInfo, e.getMessage(), e});
                }
                LOG.error("Failed to re-register node. Node {} will not be available in cloud. {}", new Object[]{nodeInfo, e.getMessage()});
            }
        }

        @Override
        protected void recordChanged(String path) {
            NodeInfo nodeInfo = (NodeInfo)CloudState.this.myInfo.get();
            if (nodeInfo == null) {
                return;
            }
            if (path.equals(IZooKeeperLayout.PATH_NODES_APPROVED.append(nodeInfo.getNodeId()).toString())) {
                try {
                    CloudState.this.refreshNodeInfoAssumingApproved();
                }
                catch (Exception e) {
                    if (CloudDebug.cloudState) {
                        LOG.warn("Smart update failed for record change event ({}) for node {}, a complete re-connect will be forced! {}", new Object[]{path, nodeInfo, e.getMessage(), e});
                    } else {
                        LOG.warn("Smart update failed for record change event ({}) for node {}, a complete re-connect will be forced! {}", new Object[]{nodeInfo, e.getMessage()});
                    }
                    this.reconnect(nodeInfo);
                }
            }
        }
    };

    public static NodeInfo getNodeInfo() {
        CloudState cloudState = instanceRef.get();
        if (cloudState == null) {
            return null;
        }
        return cloudState.myInfo.get();
    }

    public static void registerNode() throws Exception {
        if (!instanceRef.compareAndSet(null, new CloudState())) {
            throw new IllegalStateException("Already registered!");
        }
        ZooKeeperGate.addConnectionMonitor(instanceRef.get());
    }

    public static void unregisterNode() {
        CloudState cloudState = instanceRef.getAndSet(null);
        if (cloudState == null) {
            throw new IllegalStateException("Not registered!");
        }
        ZooKeeperGate.removeConnectionMonitor(cloudState);
        cloudState.state.set(State.CLOSED);
    }

    private CloudState() {
    }

    @Override
    public void connected(ZooKeeperGate gate) {
        if (!this.state.compareAndSet(State.DISCONNECTED, State.CONNECTING)) {
            LOG.warn("Received CONNECTED event but old state is not DISCONNECTED: {}", (Object)this);
            return;
        }
        new RegistrationJob().schedule();
    }

    @Override
    public void disconnected(ZooKeeperGate gate) {
        State oldState = this.state.getAndSet(State.DISCONNECTED);
        if (oldState == State.DISCONNECTED) {
            if (CloudDebug.cloudState) {
                LOG.debug("Ignoring disconnect request for already disconnected node.");
            }
            return;
        }
        if (CloudDebug.cloudState) {
            LOG.debug("Attempting node de-registration from cloud.", (Throwable)new Exception("Node Disconnect Call Stack"));
        }
        this.registrationLock.lock();
        try {
            NodeInfo nodeInfo = this.myInfo.getAndSet(null);
            if (nodeInfo == null) {
                return;
            }
            try {
                this.setNodeOffline(nodeInfo);
                ZooKeeperGate.get().deletePath(IZooKeeperLayout.PATH_NODES_ALL.append(nodeInfo.getNodeId()));
                LOG.info("Node {} is now offline.", (Object)nodeInfo);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception e) {
                LOG.warn("Unable to set node to offline. You may need to check node directory manually in order to bring the node back online. Another option would be complete shutdown and re-start after a few seconds. {}", (Object)e.toString());
            }
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    private List<String> getCloudRolesToStart() {
        List startOptions = ServerRolesRegistry.getDefault().getAllDefaultStartOptions(ServerRoleDefaultStartOption.Trigger.ON_CLOUD_CONNECT);
        INodeEnvironment nodeEnvironment = CloudActivator.getInstance().getNodeEnvironment();
        Iterator stream = startOptions.iterator();
        while (stream.hasNext()) {
            ServerRoleDefaultStartOption startOption = (ServerRoleDefaultStartOption)stream.next();
            String nodeFilter = startOption.getNodeFilter();
            if (nodeFilter == null) continue;
            try {
                if (nodeEnvironment.matches(nodeFilter)) continue;
                stream.remove();
            }
            catch (InvalidSyntaxException e) {
                stream.remove();
                LOG.error("Invalid node filter for start option of role {}. {}", (Object)startOption.getRoleId(), (Object)e.getMessage());
            }
        }
        Collections.sort(startOptions);
        ArrayList<String> roleIds = new ArrayList<String>(startOptions.size());
        for (ServerRoleDefaultStartOption roleDefaultStart : startOptions) {
            String roleId = roleDefaultStart.getRoleId();
            if (roleIds.contains(roleId)) continue;
            roleIds.add(roleId);
        }
        return roleIds;
    }

    State getConnectState() {
        return this.state.get();
    }

    private NodeInfo initializeNodeInfo() throws Exception {
        NodeInfo info;
        block3: {
            info = new NodeInfo();
            try {
                ZooKeeperGate.get().createPath(IZooKeeperLayout.PATH_NODES_ALL.append(info.getNodeId()), CreateMode.EPHEMERAL, info.getLocation());
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NODEEXISTS) break block3;
                String existingEntry = ZooKeeperGate.get().readRecord(IZooKeeperLayout.PATH_NODES_ALL.append(info.getNodeId()), (String)null, (Stat)null);
                throw new IllegalStateException(NLS.bind((String)"Node id {0} already in use by {1}! This may be a result of an unclean previous shutdown. Please retry and/or investigate if the problem still exists in a few seconds (depending on ZooKeeper session timeout).", (Object)info.getNodeId(), (Object)existingEntry));
            }
        }
        NodeInfo approvedNodeInfo = this.readApprovedNodeInfo(info.getNodeId());
        if (approvedNodeInfo != null) {
            return approvedNodeInfo;
        }
        ZooKeeperGate.get().writeRecord(IZooKeeperLayout.PATH_NODES_PENDING.append(info.getNodeId()), CreateMode.EPHEMERAL, info.getLocation());
        return info;
    }

    NodeInfo readApprovedNodeInfo(String nodeId) throws Exception {
        IPath approvedNodeIdPath = IZooKeeperLayout.PATH_NODES_APPROVED.append(nodeId);
        Stat stat = new Stat();
        int attempts = 0;
        while (ZooKeeperGate.get().exists(approvedNodeIdPath, this.monitor)) {
            try {
                byte[] record = ZooKeeperGate.get().readRecord(approvedNodeIdPath, stat);
                if (record == null) continue;
                return new NodeInfo(new ZooKeeperNodeInfo(nodeId, true, record, stat.getVersion()));
            }
            catch (KeeperException.NoNodeException noNodeException) {
                if (++attempts <= 5) continue;
                throw new IllegalStateException("Failed read approved node info. The exists call succeeds but the read call says it doesn't exist. Please verify the ZooKeeper state.");
            }
        }
        return null;
    }

    void refreshNodeInfoAssumingApproved() throws Exception {
        this.registrationLock.lock();
        try {
            NodeInfo oldInfo = this.myInfo.get();
            if (oldInfo == null) {
                throw new IllegalStateException("cloud is inactive");
            }
            NodeInfo newInfo = this.readApprovedNodeInfo(oldInfo.getNodeId());
            if (newInfo == null) {
                throw new IllegalStateException("no approved node info found");
            }
            if (!StringUtils.equals((String)oldInfo.getNodeId(), (String)newInfo.getNodeId())) {
                throw new IllegalStateException("node id mismatch");
            }
            if (oldInfo.getVersion() >= newInfo.getVersion()) {
                if (CloudDebug.cloudState) {
                    LOG.debug("Already up to date (current {} >= remote {})", (Object)oldInfo, (Object)newInfo);
                }
                return;
            }
            if (CloudDebug.cloudState) {
                LOG.debug("Updating node info to {}", (Object)newInfo);
            }
            this.myInfo.set(newInfo);
            this.refreshServerRoles();
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    private void refreshServerRoles() {
        List<String> rolesToStart = this.getCloudRolesToStart();
        List<String> alreadyStartedRoles = this.myRoles.getAndSet(rolesToStart);
        if (alreadyStartedRoles != null) {
            ArrayList<String> toStop = new ArrayList<String>(alreadyStartedRoles.size());
            for (String roledId : alreadyStartedRoles) {
                if (rolesToStart.contains(roledId)) continue;
                toStop.add(roledId);
            }
            Collections.reverse(toStop);
            LocalRolesManager.deactivateRoles(toStop);
        }
        ArrayList<String> toStart = new ArrayList<String>(rolesToStart.size());
        for (String roledId : rolesToStart) {
            if (alreadyStartedRoles != null && alreadyStartedRoles.contains(roledId)) continue;
            toStart.add(roledId);
        }
        LocalRolesManager.activateRoles(toStart);
    }

    boolean registerWithCloud() {
        this.registrationLock.lock();
        try {
            if (this.getConnectState() != State.CONNECTING) {
                return false;
            }
            NodeInfo nodeInfo = null;
            try {
                nodeInfo = this.initializeNodeInfo();
                LOG.info("Node {} initialized.", (Object)nodeInfo);
            }
            catch (Exception e) {
                if (CloudDebug.debug) {
                    LOG.error("Unable to initialize node info. Node will not be available in cloud. {}", new Object[]{e.getMessage(), e});
                } else {
                    LOG.error("Unable to initialize node info. Node will not be available in cloud. {}", new Object[]{e.getMessage()});
                }
                this.registrationLock.unlock();
                return false;
            }
            this.myInfo.set(nodeInfo);
            try {
                if (nodeInfo.isApproved()) {
                    this.setNodeOnline(nodeInfo);
                    LOG.info("Node {} is now online.", (Object)nodeInfo);
                } else if (Platform.inDevelopmentMode() && new NodeEnvironmentImpl().inStandaloneMode()) {
                    LOG.info("Attempting automatic approval of node {} in standalong development system.", (Object)nodeInfo);
                    new AutoApproveJob(nodeInfo).schedule(500L);
                } else {
                    LOG.info("Node {} needs to be approved first. Please contact cloud administrator with node details for approval.", (Object)nodeInfo);
                }
            }
            catch (Exception e) {
                if (CloudDebug.debug) {
                    LOG.error("Unable to set node to online. Node will not be available in cloud.", (Throwable)e);
                } else {
                    LOG.error("Unable to set node to online. Node will not be available in cloud. {}", (Object)e.getMessage());
                }
                this.registrationLock.unlock();
                return false;
            }
            return true;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    private void sendNodeEvent(NodeInfo node, boolean online) {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>(3);
            properties.put("node.id", node.getNodeId());
            properties.put("node.tags", node.getTags());
            properties.put("node.name", node.getName());
            properties.put("node.location", node.getLocation());
            Event event = new Event(online ? "org/eclipse/gyrex/cloud/node/online" : "org/eclipse/gyrex/cloud/node/offline", properties);
            if (CloudDebug.cloudState) {
                LOG.debug("Sending node event: {}", (Object)event);
            }
            CloudActivator.getInstance().getEventAdmin().sendEvent(event);
        }
        catch (Exception e) {
            LOG.error("Error while notifying public cloud node listeners. {}", new Object[]{e.getMessage(), e});
        }
    }

    private void setNodeOffline(NodeInfo node) throws Exception {
        block3: {
            this.sendNodeEvent(node, false);
            List roles = this.myRoles.getAndSet(null);
            if (roles != null && !roles.isEmpty()) {
                Collections.reverse(roles);
                LocalRolesManager.deactivateRoles((Collection)roles);
            }
            CloudActivator.getInstance().stopCloudServices();
            NodeMetricsReporter.stop();
            try {
                ZooKeeperGate.get().deletePath(IZooKeeperLayout.PATH_NODES_ONLINE.append(node.getNodeId()));
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NONODE) break block3;
                throw e;
            }
        }
    }

    private void setNodeOnline(NodeInfo node) throws Exception {
        block6: {
            if (!node.isApproved()) {
                throw new IllegalArgumentException(NLS.bind((String)"Node {0} must be approved first before it is allowed to join the cloud.", (Object)node.getNodeId()));
            }
            try {
                ZooKeeperGate.get().createPath(IZooKeeperLayout.PATH_NODES_ONLINE, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block6;
                throw e;
            }
        }
        try {
            ZooKeeperGate.get().writeRecord(IZooKeeperLayout.PATH_NODES_ONLINE.append(node.getNodeId()), CreateMode.EPHEMERAL, node.getLocation());
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NODEEXISTS) {
                throw new IllegalStateException(NLS.bind((String)"Unable to register node {0} in the cloud. There is already a node with that id running.", (Object)node.getNodeId()), e);
            }
            throw e;
        }
        NodeMetricsReporter.start();
        CloudActivator.getInstance().startCloudServices();
        List<String> roleIds = this.getCloudRolesToStart();
        LocalRolesManager.activateRoles(roleIds);
        this.myRoles.set(roleIds);
        this.sendNodeEvent(node, true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CloudState [").append((Object)this.state.get()).append(", ").append(this.myInfo.get()).append("]");
        return builder.toString();
    }

    static final class AutoApproveJob
    extends Job {
        private final NodeInfo nodeInfo;

        public AutoApproveJob(NodeInfo nodeInfo) {
            super("Node Auto-Approval Job");
            this.nodeInfo = nodeInfo;
            this.setSystem(true);
            this.setPriority(30);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ZooKeeperNodeInfo.approve(this.nodeInfo.getNodeId(), null, this.nodeInfo.getLocation());
                LOG.warn("Node {} approved automatically. Welcome to your local cloud!", (Object)this.nodeInfo.getNodeId());
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                LOG.error("Unable to automatically approve node {}. Please check server logs. {}", new Object[]{this.nodeInfo.getNodeId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                return Status.CANCEL_STATUS;
            }
        }
    }

    private final class RegistrationJob
    extends Job
    implements ISchedulingRule {
        private static final int MAX_DELAY = 30000;
        private static final int MIN_DELAY = 1000;
        private volatile int delay;

        public RegistrationJob() {
            super("Cloud Registration");
            this.delay = 0;
            this.setSystem(true);
            this.setRule(this);
            this.setPriority(20);
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule.getClass().getName().equals(RegistrationJob.class.getName());
        }

        private void reschedule() {
            this.delay = Math.min(30000, this.delay > 0 ? this.delay * 2 : 1000);
            LOG.warn("Node registration in cloud failed. Will retry in {} seconds.", (Object)(this.delay / 1000));
            this.schedule(this.delay);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled() || CloudState.this.getConnectState() != State.CONNECTING) {
                return Status.CANCEL_STATUS;
            }
            if (CloudDebug.cloudState) {
                LOG.debug("Attempting node registration in cloud.");
            }
            if (!CloudState.this.registerWithCloud()) {
                if (CloudState.this.getConnectState() == State.CONNECTING) {
                    this.reschedule();
                }
                return Status.CANCEL_STATUS;
            }
            if (CloudDebug.cloudState) {
                LOG.debug("Node registered in cloud!");
            }
            return Status.OK_STATUS;
        }
    }

    public static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        CLOSED;

    }
}

