/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperBasedService;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperBasedPreferences
extends ZooKeeperBasedService
implements IEclipsePreferences {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperBasedPreferences.class);
    private static final String VERSION_KEY = "gyrex.preferences.version";
    private static final String VERSION_VALUE = "1";
    private static final String[] EMPTY_NAMES_ARRAY = new String[0];
    private static final String PATH_SEPARATOR = String.valueOf('/');
    private static final String EMPTY_STRING = "";
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String TRUE = Boolean.TRUE.toString();
    private final IEclipsePreferences parent;
    private final String name;
    private final IPath path;
    private final IPath zkPath;
    private final ConcurrentMap<String, ZooKeeperBasedPreferences> children = new ConcurrentHashMap<String, ZooKeeperBasedPreferences>(4);
    private final Set<String> pendingChildRemovals = new HashSet<String>();
    private final Properties properties = new Properties();
    final AtomicBoolean connected = new AtomicBoolean();
    private final Lock childrenModifyLock = new ReentrantLock();
    private final Lock propertiesLoadOrSaveLock = new ReentrantLock();
    private final ZooKeeperMonitor monitor = new ZooKeeperMonitor(){

        @Override
        protected void childrenChanged(String path) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node {} updated remotely: CHILDREN CHANGED", (Object)path);
            }
            if (ZooKeeperBasedPreferences.this.removed) {
                return;
            }
            if (ZooKeeperBasedPreferences.this.zkPath.toString().equals(path)) {
                try {
                    ZooKeeperBasedPreferences.this.loadChildren(false);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    ZooKeeperBasedPreferences.this.connected.set(false);
                }
                catch (Exception e) {
                    ZooKeeperBasedPreferences.this.connected.set(false);
                    LOG.warn("Error refreshing children of node {}. {}", (Object)ZooKeeperBasedPreferences.this, (Object)e.getMessage());
                }
            }
        }

        @Override
        protected void pathCreated(String path) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node {} updated remotely: CREATED", (Object)path);
            }
            if (ZooKeeperBasedPreferences.this.zkPath.toString().equals(path)) {
                ZooKeeperBasedPreferences.this.removed = false;
                try {
                    ZooKeeperBasedPreferences.this.loadProperties(false);
                    ZooKeeperBasedPreferences.this.loadChildren(false);
                }
                catch (Exception e) {
                    ZooKeeperBasedPreferences.this.connected.set(false);
                    LOG.warn("Error refreshing node {}. {}", (Object)ZooKeeperBasedPreferences.this, (Object)e.getMessage());
                }
            }
        }

        @Override
        protected void pathDeleted(String path) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node {} updated remotely: REMOVED", (Object)path);
            }
            if (ZooKeeperBasedPreferences.this.removed) {
                return;
            }
            if (ZooKeeperBasedPreferences.this.zkPath.toString().equals(path)) {
                try {
                    ZooKeeperBasedPreferences.this.removeNode();
                }
                catch (BackingStoreException e) {
                    ZooKeeperBasedPreferences.this.connected.set(false);
                    LOG.warn("Error removing node {}. {}", (Object)ZooKeeperBasedPreferences.this, (Object)e.getMessage());
                }
            }
        }

        @Override
        protected void recordChanged(String path) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node {} updated remotely: PROPERTIES", (Object)path);
            }
            if (ZooKeeperBasedPreferences.this.removed) {
                return;
            }
            if (ZooKeeperBasedPreferences.this.zkPath.toString().equals(path)) {
                try {
                    ZooKeeperBasedPreferences.this.loadProperties(false);
                }
                catch (Exception e) {
                    ZooKeeperBasedPreferences.this.connected.set(false);
                    LOG.warn("Error refreshing properties of node {}. {}", (Object)ZooKeeperBasedPreferences.this, (Object)e.getMessage());
                }
            }
        }
    };
    volatile boolean removed;
    private volatile int propertiesVersion;
    private volatile int childrenVersion;
    private volatile boolean propertiesDirty;
    private volatile ListenerList nodeListeners;
    private volatile ListenerList preferenceListeners;

    public ZooKeeperBasedPreferences(IEclipsePreferences parent, String name, IPath zooKeeperParentPath) {
        super(50L, 3);
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        this.parent = parent;
        this.name = name;
        String parentPath = parent.absolutePath();
        this.path = parentPath.equals(PATH_SEPARATOR) ? new Path(name).makeAbsolute() : new Path(parentPath).append(name).makeAbsolute();
        this.zkPath = zooKeeperParentPath.append(this.path);
    }

    public String absolutePath() {
        return this.path.toString();
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        this.ensureConnectedAndLoaded();
        if (!visitor.visit((IEclipsePreferences)this)) {
            return;
        }
        Collection toVisit = this.children.values();
        for (ZooKeeperBasedPreferences child : toVisit) {
            child.accept(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        if (this.nodeListeners == null) {
            ZooKeeperBasedPreferences zooKeeperBasedPreferences = this;
            synchronized (zooKeeperBasedPreferences) {
                if (this.nodeListeners == null) {
                    this.nodeListeners = new ListenerList();
                }
            }
        }
        this.nodeListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (this.preferenceListeners == null) {
            ZooKeeperBasedPreferences zooKeeperBasedPreferences = this;
            synchronized (zooKeeperBasedPreferences) {
                if (this.preferenceListeners == null) {
                    this.preferenceListeners = new ListenerList();
                }
            }
        }
        this.preferenceListeners.add((Object)listener);
    }

    private IEclipsePreferences calculateRoot() {
        ZooKeeperBasedPreferences result = this;
        while (result.parent() != null) {
            result = (IEclipsePreferences)result.parent();
        }
        return result;
    }

    private void checkRemoved() {
        if (this.removed) {
            throw new IllegalStateException(String.format("Node '%s' has been removed.", this.name));
        }
    }

    private void childRemoved(ZooKeeperBasedPreferences child) {
        if (this.removed) {
            return;
        }
        boolean wasRemoved = false;
        this.childrenModifyLock.lock();
        try {
            if (this.removed) {
                return;
            }
            if (this.children.remove(child.name()) != null) {
                wasRemoved = true;
                this.pendingChildRemovals.add(child.name());
            }
        }
        finally {
            this.childrenModifyLock.unlock();
        }
        if (wasRemoved) {
            this.fireNodeEvent(child, false);
        }
    }

    public String[] childrenNames() throws BackingStoreException {
        try {
            this.ensureConnectedAndLoaded();
            Set names = this.children.keySet();
            return !names.isEmpty() ? names.toArray(EMPTY_NAMES_ARRAY) : EMPTY_NAMES_ARRAY;
        }
        catch (Exception e) {
            this.connected.set(false);
            throw new BackingStoreException(String.format("Error while reading children from ZooKeeper for node '%s'. %s", this, e.getMessage()), (Throwable)e);
        }
    }

    public void clear() throws BackingStoreException {
        this.ensureConnectedAndLoaded();
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
    }

    @Override
    protected void disconnect() {
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Disconnecting preference node {}.", (Object)this);
        }
        if (!this.removed && this.propertiesDirty) {
            try {
                this.saveProperties();
            }
            catch (Exception exception) {}
        }
        this.connected.set(false);
        this.childrenModifyLock.lock();
        try {
            if (this.removed) {
                return;
            }
            for (ZooKeeperBasedPreferences child : this.children.values()) {
                child.disconnect();
            }
        }
        finally {
            this.childrenModifyLock.unlock();
        }
    }

    private void ensureConnectedAndLoaded() throws IllegalStateException {
        this.checkRemoved();
        if (!this.connected.get() && this.connected.compareAndSet(false, true)) {
            try {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Connecting preference node {}.", (Object)this);
                }
                if (!ZooKeeperGate.get().exists(this.zkPath, this.monitor)) {
                    if (CloudDebug.zooKeeperPreferences) {
                        LOG.debug("Node {} connected, waiting for remote path to be created ({})", (Object)this, (Object)this.zkPath);
                    }
                    this.propertiesDirty = true;
                    return;
                }
                this.loadProperties(true);
                this.loadChildren(true);
            }
            catch (Exception e) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Exception while connecting node {}: {}", (Object)this, (Object)e.getMessage());
                    LOG.debug("Stack for connection request for node {}.", (Object)this, (Object)new Exception("Stack for preference node connection request."));
                }
                this.connected.set(false);
                throw new IllegalStateException(String.format("Error loading node '%s' from ZooKeeper. %s", this, e.getMessage()), e);
            }
        }
    }

    private void fireNodeEvent(ZooKeeperBasedPreferences child, boolean added) {
        IEclipsePreferences.NodeChangeEvent event = new IEclipsePreferences.NodeChangeEvent((Preferences)this, (Preferences)child);
        ListenerList listeners = this.nodeListeners;
        if (listeners != null) {
            Object[] objectArray = listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                if (added) {
                    ((IEclipsePreferences.INodeChangeListener)listener).added(event);
                } else {
                    ((IEclipsePreferences.INodeChangeListener)listener).removed(event);
                }
                ++n2;
            }
        }
    }

    private void firePreferenceEvent(IEclipsePreferences.PreferenceChangeEvent event) {
        ListenerList listeners = this.preferenceListeners;
        if (listeners != null) {
            Object[] objectArray = listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IEclipsePreferences.IPreferenceChangeListener)listener).preferenceChange(event);
                ++n2;
            }
        }
    }

    public void flush() throws BackingStoreException {
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Flushing node {} (version {}, cversion {})", new Object[]{this, this.propertiesVersion, this.childrenVersion});
        }
        this.ensureConnectedAndLoaded();
        try {
            this.saveProperties();
            this.saveChildren();
        }
        catch (Exception e) {
            this.connected.set(false);
            throw new BackingStoreException(String.format("Error saving node data '%s' from ZooKeeper. %s", this, e.getMessage()), (Throwable)e);
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Flushed node {} (version {}, cversion {})", new Object[]{this, this.propertiesVersion, this.childrenVersion});
        }
    }

    public String get(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.ensureConnectedAndLoaded();
        String value = this.properties.getProperty(key);
        return value == null ? def : value;
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.get(key, null);
        return value == null ? def : TRUE.equalsIgnoreCase(value);
    }

    public byte[] getByteArray(String key, byte[] def) {
        String value = this.get(key, null);
        try {
            return value == null ? def : Base64.decodeBase64((byte[])value.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support US_ASCII encoding? " + e.getMessage());
        }
    }

    public double getDouble(String key, double def) {
        String value = this.get(key, null);
        return value == null ? def : Double.valueOf(value);
    }

    public float getFloat(String key, float def) {
        String value = this.get(key, null);
        return value == null ? def : Float.valueOf(value).floatValue();
    }

    public int getInt(String key, int def) {
        String value = this.get(key, null);
        return value == null ? def : Integer.valueOf(value);
    }

    public long getLong(String key, long def) {
        String value = this.get(key, null);
        return value == null ? def : Long.valueOf(value);
    }

    @Override
    protected String getToStringDetails() {
        StringBuilder details = new StringBuilder();
        details.append(this.absolutePath());
        if (!this.connected.get()) {
            details.append(" DISCONNECTED");
        }
        return details.toString();
    }

    public String[] keys() throws BackingStoreException {
        this.ensureConnectedAndLoaded();
        if (this.properties.isEmpty()) {
            return EMPTY_NAMES_ARRAY;
        }
        Set<String> names = this.properties.stringPropertyNames();
        return names.toArray(EMPTY_NAMES_ARRAY);
    }

    void loadChildren(boolean forceSyncWithRemoteVersion) throws IllegalStateException, InterruptedException, KeeperException {
        if (this.removed) {
            return;
        }
        ArrayList<ZooKeeperBasedPreferences> addedNodes = new ArrayList<ZooKeeperBasedPreferences>(3);
        this.childrenModifyLock.lock();
        try {
            if (this.removed) {
                return;
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Loading children for node {} (cversion {}) from {}", new Object[]{this, this.childrenVersion, this.zkPath});
            }
            Stat stat = new Stat();
            Collection<String> childrenNames = ZooKeeperGate.get().readChildrenNames(this.zkPath, this.monitor, stat);
            if (!forceSyncWithRemoteVersion && this.childrenVersion >= stat.getCversion()) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Not updating children of node {} - local cversion ({}) >= ZooKeeper cversion ({})", new Object[]{this, this.childrenVersion, stat.getCversion()});
                }
                return;
            }
            this.childrenVersion = stat.getCversion();
            for (String name : childrenNames) {
                if (!this.children.containsKey(name)) {
                    ZooKeeperBasedPreferences child = this.newChild(name);
                    this.children.put(name, child);
                    addedNodes.add(child);
                }
                if (!this.pendingChildRemovals.contains(name)) continue;
                this.pendingChildRemovals.remove(name);
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Loaded children for node {} (now at cversion {})", (Object)this, (Object)this.childrenVersion);
            }
        }
        finally {
            this.childrenModifyLock.unlock();
        }
        for (ZooKeeperBasedPreferences child : addedNodes) {
            this.fireNodeEvent(child, true);
        }
    }

    void loadProperties(boolean forceSyncWithRemoteVersion) throws KeeperException, InterruptedException, IOException {
        if (this.removed) {
            return;
        }
        ArrayList<IEclipsePreferences.PreferenceChangeEvent> events = new ArrayList<IEclipsePreferences.PreferenceChangeEvent>();
        this.propertiesLoadOrSaveLock.lock();
        try {
            if (this.removed) {
                return;
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Reading properties for node {} (version {}) from ZooKeeper {}", new Object[]{this, this.propertiesVersion, this.zkPath});
            }
            Stat stat = new Stat();
            byte[] bytes = ZooKeeperGate.get().readRecord(this.zkPath, this.monitor, stat);
            if (!forceSyncWithRemoteVersion && this.propertiesVersion >= stat.getVersion()) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Not updating properties of node {} - local version ({}) >= ZooKeeper version ({})", new Object[]{this, this.propertiesVersion, stat.getVersion()});
                }
                return;
            }
            this.propertiesVersion = stat.getVersion();
            Properties loadedProps = new Properties();
            if (bytes != null) {
                loadedProps.load(new ByteArrayInputStream(bytes));
                Object version = loadedProps.remove(VERSION_KEY);
                if (version == null || !VERSION_VALUE.equals(version)) {
                    LOG.warn("Properties with incompatible storage format version ({}) found for node {}.", version, (Object)this);
                    return;
                }
            }
            HashSet<String> propertyNames = new HashSet<String>();
            propertyNames.addAll(loadedProps.stringPropertyNames());
            propertyNames.addAll(this.properties.stringPropertyNames());
            for (String key : propertyNames) {
                String newValue = loadedProps.getProperty(key);
                String oldValue = this.properties.getProperty(key);
                if (newValue == null) {
                    this.properties.remove(key);
                    if (CloudDebug.zooKeeperPreferences) {
                        LOG.debug("Node {} property removed: {}", (Object)key);
                    }
                    events.add(new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, (Object)oldValue, (Object)newValue));
                    continue;
                }
                if (oldValue != null && oldValue.equals(newValue)) continue;
                this.properties.put(key, newValue);
                if (CloudDebug.zooKeeperPreferences) {
                    if (oldValue == null) {
                        LOG.debug("Node {} property added: {} - {}", (Object)key, (Object)newValue);
                    } else {
                        LOG.debug("Node {} property updated: {} - {}", (Object)key, (Object)newValue);
                    }
                }
                events.add(new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, (Object)oldValue, (Object)newValue));
            }
            this.propertiesDirty = false;
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Loaded properties for node {} (now at version {})", (Object)this, (Object)this.propertiesVersion);
            }
        }
        finally {
            this.propertiesLoadOrSaveLock.unlock();
        }
        for (IEclipsePreferences.PreferenceChangeEvent event : events) {
            this.firePreferenceEvent(event);
        }
    }

    public String name() {
        return this.name;
    }

    protected abstract ZooKeeperBasedPreferences newChild(String var1);

    public Preferences node(String path) {
        this.checkRemoved();
        if (path.length() == 0) {
            return this;
        }
        if (path.charAt(0) == '/') {
            return this.calculateRoot().node(path.substring(1));
        }
        this.ensureConnectedAndLoaded();
        int index = path.indexOf(47);
        String key = index == -1 ? path : path.substring(0, index);
        ZooKeeperBasedPreferences child = (ZooKeeperBasedPreferences)this.children.get(key);
        boolean added = false;
        if (child == null) {
            this.childrenModifyLock.lock();
            try {
                child = (ZooKeeperBasedPreferences)this.children.get(key);
                while (child == null) {
                    if (!this.children.containsKey(key)) {
                        this.children.put(key, this.newChild(key));
                        added = true;
                        this.pendingChildRemovals.remove(key);
                    }
                    child = (ZooKeeperBasedPreferences)this.children.get(key);
                }
            }
            finally {
                this.childrenModifyLock.unlock();
            }
        }
        if (added) {
            this.fireNodeEvent(child, true);
        }
        return child.node(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        boolean noSlash;
        if (pathName.length() == 0) {
            return !this.removed;
        }
        this.ensureConnectedAndLoaded();
        if (pathName.charAt(0) == '/') {
            return this.calculateRoot().nodeExists(pathName.substring(1));
        }
        int index = pathName.indexOf(47);
        boolean bl = noSlash = index == -1;
        if (noSlash) {
            return this.children.get(pathName) != null;
        }
        String childName = pathName.substring(0, index);
        ZooKeeperBasedPreferences child = (ZooKeeperBasedPreferences)this.children.get(childName);
        if (child == null) {
            return false;
        }
        return child.nodeExists(pathName.substring(index + 1));
    }

    public Preferences parent() {
        return this.parent;
    }

    public void put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.ensureConnectedAndLoaded();
        String oldValue = this.properties.getProperty(key);
        if (value.equals(oldValue)) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("[PUT] {} - {}: {}", new Object[]{this, key, value});
        }
        this.properties.setProperty(key, value);
        this.propertiesDirty = true;
        this.firePreferenceEvent(new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, (Object)oldValue, (Object)value));
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, value ? TRUE : FALSE);
    }

    public void putByteArray(String key, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        try {
            this.put(key, new String(Base64.encodeBase64((byte[])value), "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support US_ASCII encoding? " + e.getMessage());
        }
    }

    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    @Override
    protected void reconnect() {
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Reconnecting preference node {}.", (Object)this);
        }
        this.ensureConnectedAndLoaded();
    }

    public void remove(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.ensureConnectedAndLoaded();
        String oldValue = this.properties.getProperty(key);
        if (oldValue == null) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("[REMOVE] {} - {}", new Object[]{this, key});
        }
        this.properties.remove(key);
        this.propertiesDirty = true;
        this.firePreferenceEvent(new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, (Object)oldValue, null));
    }

    public void removeNode() throws BackingStoreException {
        this.checkRemoved();
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
        try {
            if (this.parent != null && this.parent instanceof ZooKeeperBasedPreferences) {
                this.removed = true;
                ((ZooKeeperBasedPreferences)this.parent).childRemoved(this);
            }
            Collection childNodes = this.children.values();
            for (ZooKeeperBasedPreferences child : childNodes) {
                try {
                    child.removeNode();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        finally {
            if (this.removed) {
                this.connected.set(false);
                this.nodeListeners = null;
                this.preferenceListeners = null;
                this.properties.clear();
                this.children.clear();
                this.propertiesVersion = -1;
                this.childrenVersion = -1;
            }
        }
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        if (this.nodeListeners != null) {
            this.nodeListeners.remove((Object)listener);
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (this.preferenceListeners != null) {
            this.preferenceListeners.remove((Object)listener);
        }
    }

    private void saveChildren() throws BackingStoreException, KeeperException, InterruptedException, IOException {
        if (this.removed) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Saving children of node {} (cversion {})", (Object)this, (Object)this.childrenVersion);
        }
        this.childrenModifyLock.lock();
        try {
            if (this.removed) {
                return;
            }
            Collection childNodes = this.children.values();
            for (ZooKeeperBasedPreferences child : childNodes) {
                child.flush();
            }
            for (String childName : this.pendingChildRemovals) {
                IPath childPath = this.zkPath.append(childName);
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Removing child node {} at {}", (Object)childName, (Object)childPath);
                }
                ZooKeeperGate.get().deletePath(childPath);
            }
            this.pendingChildRemovals.clear();
        }
        finally {
            this.childrenModifyLock.unlock();
        }
    }

    private void saveProperties() throws KeeperException, InterruptedException, IOException {
        if (this.removed) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Saving properties of node {} (version {})", (Object)this, (Object)this.propertiesVersion);
        }
        if (!this.propertiesDirty) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Aborting property saving of node {} - properties not dirty", (Object)this);
            }
            return;
        }
        this.propertiesLoadOrSaveLock.lock();
        try {
            if (this.removed) {
                return;
            }
            Properties toSave = new Properties();
            Set<Object> keys = this.properties.keySet();
            for (Object key : keys) {
                Object value = this.properties.get(key);
                if (value == null) continue;
                toSave.put(key, value);
            }
            toSave.put(VERSION_KEY, VERSION_VALUE);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            toSave.store(out, null);
            this.propertiesVersion = ZooKeeperGate.get().writeRecord(this.zkPath, CreateMode.PERSISTENT, out.toByteArray()).getVersion();
            this.propertiesDirty = false;
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Saved properties of node {} (now at version {})", (Object)this, (Object)this.propertiesVersion);
            }
        }
        finally {
            this.propertiesLoadOrSaveLock.unlock();
        }
    }

    public void sync() throws BackingStoreException {
        this.ensureConnectedAndLoaded();
        this.syncTree();
        this.flush();
    }

    void syncTree() throws BackingStoreException {
        try {
            this.loadProperties(true);
            this.loadChildren(true);
        }
        catch (Exception e) {
            this.connected.set(false);
            throw new BackingStoreException(String.format("Error loading node data '%s' from ZooKeeper. %s", this, ExceptionUtils.getMessage((Throwable)e)), (Throwable)e);
        }
        this.childrenModifyLock.lock();
        try {
            if (this.removed) {
                return;
            }
            for (ZooKeeperBasedPreferences child : this.children.values()) {
                child.syncTree();
            }
        }
        finally {
            this.childrenModifyLock.unlock();
        }
    }
}

