/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.queue;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.eclipse.gyrex.cloud.internal.queue.QueueOperationFailedException;
import org.eclipse.gyrex.cloud.internal.queue.ZooKeeperQueue;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.services.queue.DuplicateQueueException;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.common.identifiers.IdHelper;

public class ZooKeeperQueueService
implements IQueueService {
    @Override
    public IQueue createQueue(String id, Map<String, ?> properties) throws IllegalArgumentException, IllegalStateException, SecurityException, DuplicateQueueException {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id");
        }
        try {
            ZooKeeperGate.get().createPath(IZooKeeperLayout.PATH_QUEUES_ROOT.append(id), CreateMode.PERSISTENT, this.getQueueData(properties));
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NodeExistsException) {
                throw new DuplicateQueueException(String.format("queue '%s' already exists", id));
            }
            throw new QueueOperationFailedException(id, "CREATE_QUEUE", e);
        }
        return new ZooKeeperQueue(id);
    }

    @Override
    public void deleteQueue(String id, Map<String, ?> properties) throws IllegalArgumentException, IllegalStateException, SecurityException, NoSuchElementException {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id");
        }
        try {
            ZooKeeperGate.get().deletePath(IZooKeeperLayout.PATH_QUEUES_ROOT.append(id));
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                throw new NoSuchElementException(String.format("queue '%s' does not exist", id));
            }
            throw new QueueOperationFailedException(id, "DELETE_QUEUE", e);
        }
    }

    @Override
    public IQueue getQueue(String id, Map<String, ?> properties) throws IllegalArgumentException, IllegalStateException, SecurityException {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id");
        }
        try {
            if (ZooKeeperGate.get().exists(IZooKeeperLayout.PATH_QUEUES_ROOT.append(id))) {
                return new ZooKeeperQueue(id);
            }
            return null;
        }
        catch (Exception e) {
            throw new QueueOperationFailedException(id, "GET_QUEUE", e);
        }
    }

    private byte[] getQueueData(Map<String, ?> properties) throws IOException {
        ByteArrayOutputStream queueData = new ByteArrayOutputStream();
        if (properties != null) {
            Properties p = new Properties();
            Object timeout = properties.get("queue.message.receive.timeout");
            if (timeout != null) {
                p.setProperty("queue.message.receive.timeout", String.valueOf(timeout));
            }
            if (!p.isEmpty()) {
                p.store(queueData, null);
            }
        }
        return queueData.toByteArray();
    }

    @Override
    public IQueue updateQueue(String id, Map<String, ?> properties) throws IllegalArgumentException, IllegalStateException, SecurityException, NoSuchElementException {
        try {
            ZooKeeperGate.get().writeRecord(IZooKeeperLayout.PATH_QUEUES_ROOT.append(id), this.getQueueData(properties), -1);
            return new ZooKeeperQueue(id);
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                throw new NoSuchElementException(String.format("queue '%s' does not exist", id));
            }
            throw new QueueOperationFailedException(id, "UPDATE_QUEUE", e);
        }
    }
}

