/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.KeeperException;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperBasedService {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperBasedService.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ZooKeeperGate.IConnectionMonitor connectionMonitor = new ZooKeeperGate.IConnectionMonitor(){
        private final AtomicBoolean everConnected = new AtomicBoolean();

        @Override
        public void connected(ZooKeeperGate gate) {
            if (!this.everConnected.compareAndSet(false, true)) {
                ZooKeeperBasedService.this.reconnect();
            }
        }

        @Override
        public void disconnected(ZooKeeperGate gate) {
            ZooKeeperBasedService.this.disconnect();
        }
    };
    private final long retryDelay;
    private final int retryCount;

    public ZooKeeperBasedService() {
        this(250L, 8);
    }

    public ZooKeeperBasedService(long retryDelay, int retryCount) {
        if (retryDelay < 50L) {
            throw new IllegalArgumentException("retry delay to low");
        }
        if (retryCount < 1) {
            throw new IllegalArgumentException("retry count to low");
        }
        this.retryDelay = retryDelay;
        this.retryCount = retryCount;
        ZooKeeperGate.addConnectionMonitor(this.connectionMonitor);
    }

    protected final void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.doClose();
            }
            finally {
                ZooKeeperGate.removeConnectionMonitor(this.connectionMonitor);
            }
        }
    }

    protected void disconnect() {
        LOG.warn("Connection to the cloud has been lost. Closing active service {}.", (Object)this);
        this.close();
    }

    protected void doClose() {
    }

    protected <V> V execute(Callable<V> operation) throws Exception {
        KeeperException.ConnectionLossException exception = null;
        int i = 0;
        while (i < this.retryCount) {
            try {
                return operation.call();
            }
            catch (KeeperException.SessionExpiredException e) {
                LOG.warn("ZooKeeper session expired for service {}. The service may be invalid now.", (Object)this);
                throw e;
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                if (CloudDebug.debug) {
                    LOG.debug("Connection to the server has been lost (retry attempt {}).", (Object)i);
                }
                this.sleep(i);
                ++i;
            }
        }
        throw exception;
    }

    protected abstract String getToStringDetails();

    protected final boolean isClosed() {
        return this.closed.get();
    }

    protected void reconnect() {
    }

    protected final void sleep(int attemptCount) {
        if (attemptCount > 0) {
            try {
                long sleepTime = (long)attemptCount * this.retryDelay;
                if (CloudDebug.debug) {
                    LOG.debug("Will sleep for {}ms.", (Object)sleepTime);
                }
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                if (CloudDebug.debug) {
                    LOG.debug("Sleep interrupted.");
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        if (this.isClosed()) {
            builder.append(" CLOSED");
        }
        builder.append(" [").append(this.getToStringDetails()).append("]");
        return builder.toString();
    }
}

