/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class ZooKeeperConsoleCommands
implements CommandProvider {
    static final Map<String, Command> zkCommands = new TreeMap<String, Command>();

    static {
        zkCommands.put("create", new Command("[-s] [-e] path [data]"){

            @Override
            public void execute(ZooKeeper zk, CommandInterpreter ci) throws Exception {
                String a1 = ci.nextArgument();
                String a2 = ci.nextArgument();
                if (a1 == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                CreateMode flags = CreateMode.PERSISTENT;
                if (a2 != null && (a1.equals("-e") && a2.equals("-s") || a1.equals("-s") && a2.equals("-e"))) {
                    flags = CreateMode.EPHEMERAL_SEQUENTIAL;
                    a1 = ci.nextArgument();
                    a2 = ci.nextArgument();
                } else if (a1.equals("-e")) {
                    a1 = a2;
                    a2 = ci.nextArgument();
                    flags = CreateMode.EPHEMERAL;
                } else if (a1.equals("-s")) {
                    a1 = a2;
                    a2 = ci.nextArgument();
                    flags = CreateMode.PERSISTENT_SEQUENTIAL;
                }
                if (a1 == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                String newPath = zk.create(a1, a2 != null ? a2.getBytes() : null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, flags);
                ci.println((Object)("Created " + newPath));
            }
        });
        zkCommands.put("ls", new Command("[-r] path"){

            @Override
            public void execute(ZooKeeper zk, CommandInterpreter ci) throws Exception {
                String path = ci.nextArgument();
                if (path == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                boolean recursive = false;
                if (path.equals("-r")) {
                    path = ci.nextArgument();
                    recursive = true;
                }
                if (path == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                if (recursive) {
                    this.printTree(path, 0, zk, ci);
                } else {
                    List children = zk.getChildren(path, false);
                    for (String child : children) {
                        ci.println((Object)child);
                    }
                }
            }

            private void printTree(String path, int indent, ZooKeeper zk, CommandInterpreter ci) throws Exception {
                List children = zk.getChildren(path, false);
                StrBuilder spaces = new StrBuilder();
                int i = 0;
                while (i < indent) {
                    spaces.append(" ");
                    ++i;
                }
                ci.println((Object)spaces.append(path).append(" (").append(children.size()).append(")"));
                for (String child : children) {
                    this.printTree(String.valueOf(path) + (path.equals("/") ? "" : "/") + child, indent + 1, zk, ci);
                }
            }
        });
        zkCommands.put("rm", new Command("[-r] path"){

            private void deleteTree(ZooKeeper zk, String path) throws InterruptedException, KeeperException {
                List children = zk.getChildren(path.toString(), false);
                for (String child : children) {
                    this.deleteTree(zk, String.valueOf(path) + (path.equals("/") ? "" : "/") + child);
                }
                zk.delete(path, -1);
            }

            @Override
            public void execute(ZooKeeper zk, CommandInterpreter ci) throws Exception {
                String path = ci.nextArgument();
                if (path == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                boolean recursive = false;
                if (path.equals("-r")) {
                    path = ci.nextArgument();
                    recursive = true;
                }
                if (path == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                if (recursive) {
                    this.deleteTree(zk, path);
                } else {
                    zk.delete(path, -1);
                }
                ci.println((Object)("Removed " + path));
            }
        });
        zkCommands.put("get", new Command("path"){

            @Override
            public void execute(ZooKeeper zk, CommandInterpreter ci) throws Exception {
                String path = ci.nextArgument();
                if (path == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                byte[] data = zk.getData(path, false, null);
                data = data == null ? "null".getBytes() : data;
                ci.println((Object)new String(data));
            }
        });
        zkCommands.put("set", new Command("path data"){

            @Override
            public void execute(ZooKeeper zk, CommandInterpreter ci) throws Exception {
                String path = ci.nextArgument();
                String data = ci.nextArgument();
                if (path == null || data == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                zk.setData(path, data.getBytes(), -1);
                ci.println((Object)("Updated " + path));
            }
        });
        zkCommands.put("stat", new Command("path"){

            @Override
            public void execute(ZooKeeper zk, CommandInterpreter ci) throws Exception {
                String path = ci.nextArgument();
                if (path == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                Stat stat = zk.exists(path, false);
                ci.println((Object)("cZxid: 0x" + Long.toHexString(stat.getCzxid())));
                ci.println((Object)("ctime: " + new Date(stat.getCtime()).toString()));
                ci.println((Object)("mZxid: 0x" + Long.toHexString(stat.getMzxid())));
                ci.println((Object)("mtime: " + new Date(stat.getMtime()).toString()));
                ci.println((Object)("pZxid: 0x" + Long.toHexString(stat.getPzxid())));
                ci.println((Object)("cversion: " + stat.getCversion()));
                ci.println((Object)("dataVersion: " + stat.getVersion()));
                ci.println((Object)("aclVersion: " + stat.getAversion()));
                ci.println((Object)("ephemeralOwner: 0x" + Long.toHexString(stat.getEphemeralOwner())));
                ci.println((Object)("dataLength: " + stat.getDataLength()));
                ci.println((Object)("numChildren: " + stat.getNumChildren()));
            }
        });
        zkCommands.put("sync", new Command("path"){

            @Override
            public void execute(ZooKeeper zk, CommandInterpreter ci) throws Exception {
                String path = ci.nextArgument();
                if (path == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                zk.sync(path, new AsyncCallback.VoidCallback(){

                    public void processResult(int rc, String path, Object ctx) {
                        ((CommandInterpreter)ctx).println((Object)("Synched " + path + " (rc:" + rc + ")"));
                    }
                }, (Object)ci);
            }
        });
    }

    static void _zkHelp(CommandInterpreter ci) {
        ci.println((Object)"zk <cmd> [args]");
        for (String cmd : zkCommands.keySet()) {
            ci.println((Object)("\t" + cmd + " " + zkCommands.get(cmd).getHelp()));
        }
    }

    public void _zk(CommandInterpreter ci) throws Exception {
        String command = ci.nextArgument();
        if (command == null) {
            ZooKeeperConsoleCommands._zkHelp(ci);
            return;
        }
        Command cmd = zkCommands.get(command);
        if (cmd == null) {
            ci.println((Object)("ERROR: unknown ZooKeeper command " + command));
            ZooKeeperConsoleCommands._zkHelp(ci);
            return;
        }
        ZooKeeper keeper = null;
        try {
            keeper = ZooKeeperGate.get().ensureConnected();
        }
        catch (Exception e) {
            ci.println((Object)("ZooKeeper not connected! " + e.getMessage()));
            return;
        }
        try {
            cmd.execute(keeper, ci);
        }
        catch (Exception e) {
            if (CloudDebug.debug) {
                ci.printStackTrace((Throwable)e);
            }
            ci.println((Object)("ERROR: " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
    }

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        help.appendln("---ZooKeeper Commands---");
        help.appendln("\tzk <cmd> [args]");
        for (String cmd : zkCommands.keySet()) {
            help.appendln("\t\t" + cmd + " " + zkCommands.get(cmd).getHelp());
        }
        return help.toString();
    }

    static abstract class Command {
        private final String help;

        public Command(String help) {
            this.help = help;
        }

        public abstract void execute(ZooKeeper var1, CommandInterpreter var2) throws Exception;

        public String getHelp() {
            return this.help;
        }

        protected void printInvalidArgs(CommandInterpreter ci) {
            ci.println((Object)"ERROR: invalid arguments");
            ci.println((Object)("\t" + this.getHelp()));
        }
    }
}

