/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateConfig;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperHelper;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperGate {
    private static final ListenerList connectionListeners = new ListenerList(1);
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperGate.class);
    private static final AtomicReference<ZooKeeperGate> instanceRef = new AtomicReference();
    private static final AtomicBoolean connected = new AtomicBoolean();
    private final ZooKeeper zooKeeper;
    private final IConnectionMonitor reconnectMonitor;
    private final Watcher connectionMonitor = new Watcher(){

        public void process(WatchedEvent event) {
            if (!ZooKeeperGate.isCurrentGate(ZooKeeperGate.this) && CloudDebug.zooKeeperGateLifecycle) {
                LOG.debug("Ignored connection event for inactive gate: {}, {}", (Object)this, (Object)event);
            }
            if (CloudDebug.zooKeeperGateLifecycle) {
                LOG.debug("Connection event: {}", (Object)event);
            }
            switch (event.getState()) {
                case SyncConnected: {
                    LOG.info("ZooKeeper Gate is now UP. Connection to cloud established.");
                    connected.set(true);
                    ZooKeeperGate.this.fireConnectionEvent(true);
                    break;
                }
                case Disconnected: 
                case Expired: {
                    LOG.info("ZooKeeper Gate is now DOWN. Connection to cloud lost.");
                    connected.set(false);
                    ZooKeeperGate.this.shutdown(true);
                    break;
                }
                case AuthFailed: {
                    LOG.warn("ZooKeeper Gate is unable to connect. Authentication faild.");
                    connected.set(false);
                    ZooKeeperGate.this.shutdown(false);
                    break;
                }
                default: {
                    LOG.warn("ZooKeeper is now {}. Gate is not intervening. ({})", (Object)event.getState(), (Object)ZooKeeperGate.this.zooKeeper);
                }
            }
        }
    };

    public static void addConnectionMonitor(IConnectionMonitor connectionMonitor) {
        if (connectionMonitor == null) {
            return;
        }
        connectionListeners.add((Object)connectionMonitor);
        if (connected.get()) {
            SafeRunner.run((ISafeRunnable)new NotifyConnectionListener(true, connectionMonitor, instanceRef.get()));
        }
    }

    private static String gateDownError(ZooKeeperGate gate) {
        try {
            return String.format("ZooKeeper Gate is DOWN. (%s)", String.valueOf(gate));
        }
        catch (Throwable e) {
            if (e instanceof VirtualMachineError || e instanceof LinkageError) {
                throw (Error)e;
            }
            return String.format("ZooKeeper Gate is DOWN. (%s)", ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public static ZooKeeperGate get() throws IllegalStateException {
        ZooKeeperGate gate = instanceRef.get();
        if (gate == null) {
            throw new IllegalStateException(ZooKeeperGate.gateDownError(null));
        }
        return gate;
    }

    static ZooKeeperGate getAndSet(ZooKeeperGate gate) {
        ZooKeeperGate old = instanceRef.getAndSet(gate);
        if (CloudDebug.zooKeeperGateLifecycle) {
            LOG.debug("Set new ZooKeeper Gate instance. {} (old {})", new Object[]{gate, old});
        }
        return old;
    }

    static boolean isCurrentGate(ZooKeeperGate gate) {
        return gate != null && gate == instanceRef.get();
    }

    public static void removeConnectionMonitor(IConnectionMonitor connectionMonitor) {
        if (connectionMonitor == null) {
            throw new IllegalArgumentException("connection monitor must not be null");
        }
        boolean notify = connected.get();
        connectionListeners.remove((Object)connectionMonitor);
        if (notify) {
            SafeRunner.run((ISafeRunnable)new NotifyConnectionListener(false, connectionMonitor, instanceRef.get()));
        }
    }

    ZooKeeperGate(ZooKeeperGateConfig config, IConnectionMonitor reconnectMonitor) throws IOException {
        this.reconnectMonitor = reconnectMonitor;
        this.zooKeeper = new ZooKeeper(config.getConnectString(), config.getSessionTimeout(), this.connectionMonitor);
        if (CloudDebug.zooKeeperGateLifecycle) {
            LOG.debug("New ZooKeeper Gate instance. {}", (Object)this, (Object)new Exception("ZooKeeper Gate Constructor Call Stack"));
        }
    }

    private IPath create(IPath path, CreateMode createMode, byte[] data) throws InterruptedException, KeeperException, IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (createMode == null) {
            throw new IllegalArgumentException("createMode must not be null");
        }
        ZooKeeperHelper.createParents(this.ensureConnected(), path);
        return new Path(this.ensureConnected().create(path.toString(), data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode));
    }

    public IPath createPath(IPath path, CreateMode createMode) throws KeeperException, InterruptedException, IOException {
        return this.create(path, createMode, null);
    }

    public IPath createPath(IPath path, CreateMode createMode, byte[] recordData) throws KeeperException, InterruptedException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        return this.create(path, createMode, recordData);
    }

    public IPath createPath(IPath path, CreateMode createMode, String recordData) throws KeeperException, InterruptedException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        try {
            return this.createPath(path, createMode, recordData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8.", e);
        }
    }

    public void deletePath(IPath path) throws KeeperException, InterruptedException, IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        try {
            List children = this.ensureConnected().getChildren(path.toString(), false);
            for (String child : children) {
                this.deletePath(path.append(child));
            }
            this.ensureConnected().delete(path.toString(), -1);
        }
        catch (KeeperException e) {
            if (e.code() != KeeperException.Code.NONODE) {
                throw e;
            }
            return;
        }
    }

    public void deletePath(IPath path, int version) throws InterruptedException, IOException, KeeperException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        List children = this.ensureConnected().getChildren(path.toString(), false);
        for (String child : children) {
            this.deletePath(path.append(child));
        }
        this.ensureConnected().delete(path.toString(), version);
    }

    final ZooKeeper ensureConnected() {
        if (!this.zooKeeper.getState().isAlive()) {
            throw new IllegalStateException(ZooKeeperGate.gateDownError(this));
        }
        return this.zooKeeper;
    }

    public boolean exists(IPath path) throws InterruptedException, KeeperException {
        return this.exists(path, null);
    }

    public boolean exists(IPath path, ZooKeeperMonitor monitor) throws InterruptedException, KeeperException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        return this.ensureConnected().exists(path.toString(), (Watcher)monitor) != null;
    }

    void fireConnectionEvent(boolean connected) {
        Object[] listeners;
        Object[] objectArray = listeners = connectionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new NotifyConnectionListener(connected, listener, this));
            ++n2;
        }
        if (this.reconnectMonitor != null) {
            SafeRunner.run((ISafeRunnable)new NotifyConnectionListener(connected, this.reconnectMonitor, this));
        }
    }

    public long getSessionId() {
        return this.ensureConnected().getSessionId();
    }

    public Collection<String> readChildrenNames(IPath path, Stat stat) throws InterruptedException, KeeperException {
        return this.readChildrenNames(path, null, stat);
    }

    public Collection<String> readChildrenNames(IPath path, ZooKeeperMonitor watch, Stat stat) throws KeeperException.NoNodeException, KeeperException, InterruptedException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        return this.ensureConnected().getChildren(path.toString(), (Watcher)watch, stat);
    }

    public byte[] readRecord(IPath path, Stat stat) throws KeeperException.NoNodeException, KeeperException, InterruptedException, IOException {
        return this.readRecord(path, (ZooKeeperMonitor)null, stat);
    }

    public String readRecord(IPath path, String defaultValue, Stat stat) throws KeeperException, InterruptedException, IOException {
        try {
            byte[] data = this.readRecord(path, stat);
            if (data == null) {
                return defaultValue;
            }
            return new String(data, "UTF-8");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return defaultValue;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8.", e);
        }
    }

    public byte[] readRecord(IPath path, ZooKeeperMonitor watch, Stat stat) throws KeeperException.NoNodeException, KeeperException, InterruptedException, IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        return this.ensureConnected().getData(path.toString(), (Watcher)watch, stat);
    }

    private Stat setData(IPath path, CreateMode createMode, byte[] data, int version) throws InterruptedException, KeeperException, IOException {
        block4: {
            if (path == null) {
                throw new IllegalArgumentException("path must not be null");
            }
            if (createMode != null && !this.exists(path)) {
                try {
                    this.create(path, createMode, data);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NODEEXISTS) break block4;
                    throw e;
                }
            }
        }
        return this.ensureConnected().setData(path.toString(), data, version);
    }

    void shutdown(boolean notify) {
        block5: {
            if (CloudDebug.zooKeeperGateLifecycle) {
                LOG.debug("Shutdown of ZooKeeper Gate. {}", (Object)this, (Object)new Exception("ZooKeeper Gate Shutdown Call Stack"));
            }
            if (notify) {
                this.fireConnectionEvent(false);
            }
            try {
                this.zooKeeper.close();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                if (!CloudDebug.zooKeeperGateLifecycle) break block5;
                LOG.debug("Ignored exception during shutdown: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void testShutdown() throws InterruptedException {
        this.shutdown(true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ZooKeeperGate [current=");
        builder.append(ZooKeeperGate.isCurrentGate(this));
        builder.append(", zk=");
        builder.append(this.zooKeeper);
        builder.append("]");
        return builder.toString();
    }

    public Stat writeRecord(IPath path, byte[] recordData, int version) throws InterruptedException, KeeperException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        return this.setData(path, null, recordData, version);
    }

    public Stat writeRecord(IPath path, CreateMode createMode, byte[] recordData) throws KeeperException, InterruptedException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        if (createMode == null) {
            throw new IllegalArgumentException("createMode must not be null");
        }
        return this.setData(path, createMode, recordData, -1);
    }

    public Stat writeRecord(IPath path, CreateMode createMode, String recordData) throws KeeperException, InterruptedException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        if (createMode == null) {
            throw new IllegalArgumentException("createMode must not be null");
        }
        try {
            return this.writeRecord(path, createMode, recordData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8.", e);
        }
    }

    public Stat writeRecord(IPath path, String recordData, int version) throws InterruptedException, KeeperException, IOException {
        try {
            return this.writeRecord(path, recordData.getBytes("UTF-8"), version);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8.", e);
        }
    }

    public static interface IConnectionMonitor {
        public void connected(ZooKeeperGate var1);

        public void disconnected(ZooKeeperGate var1);
    }

    private static final class NotifyConnectionListener
    implements ISafeRunnable {
        private final boolean connected;
        private final Object listener;
        private final ZooKeeperGate gate;

        private NotifyConnectionListener(boolean connected, Object listener, ZooKeeperGate gate) {
            this.connected = connected;
            this.listener = listener;
            this.gate = gate;
        }

        public void handleException(Throwable e) {
            LOG.error("Removing bogous connection listener {} due to exception ({}).", new Object[]{this.listener, ExceptionUtils.getMessage((Throwable)e), e});
            connectionListeners.remove(this.listener);
        }

        public void run() throws Exception {
            if (this.connected) {
                ((IConnectionMonitor)this.listener).connected(this.gate);
            } else {
                ((IConnectionMonitor)this.listener).disconnected(this.gate);
            }
        }
    }
}

