/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.server.Platform;

public class ZooKeeperServerConfig
extends QuorumPeerConfig {
    public static final String PREF_KEY_CLIENT_PORT = "zookeeper/server/clientPort";
    public static final String PREF_KEY_CLIENT_PORT_ADDRESS = "zookeeper/clientPortAddress";
    public static final String PREF_KEY_TICKTIME = "zookeeper/ticktime";
    private boolean preferencesBased;

    public ZooKeeperServerConfig() {
        IPath zkBase = Platform.getInstanceLocation().append("zookeeper");
        this.dataDir = zkBase.toString();
        this.dataLogDir = zkBase.append("logs").toString();
    }

    public boolean isPreferencesBased() {
        return this.preferencesBased;
    }

    public void readFromPreferences() throws QuorumPeerConfig.ConfigException {
        this.preferencesBased = true;
        IPreferencesService preferenceService = CloudActivator.getInstance().getPreferenceService();
        int clientPort = preferenceService.getInt("org.eclipse.gyrex.cloud", PREF_KEY_CLIENT_PORT, 2181, null);
        String clientPortBindAddress = preferenceService.getString("org.eclipse.gyrex.cloud", PREF_KEY_CLIENT_PORT_ADDRESS, null, null);
        if (clientPortBindAddress != null) {
            try {
                this.clientPortAddress = new InetSocketAddress(InetAddress.getByName(clientPortBindAddress), clientPort);
            }
            catch (UnknownHostException e) {
                throw new QuorumPeerConfig.ConfigException("Invalid clientPortAddress hostname. " + e.getMessage());
            }
        } else {
            this.clientPortAddress = new InetSocketAddress(clientPort);
        }
        this.tickTime = preferenceService.getInt("org.eclipse.gyrex.cloud", PREF_KEY_TICKTIME, 2000, null);
    }
}

