/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUiHttpServiceTracker
extends ServiceTracker<HttpService, HttpService> {
    private static final Logger LOG = LoggerFactory.getLogger(AdminUiHttpServiceTracker.class);
    private static final String ROOT_ALIAS = "/";
    static final String FILTER_ADMIN_HTTP_SERVICE = "(&(objectClass=" + HttpService.class.getName() + ")(other.info=" + "org.eclipse.gyrex.admin.ui.http" + "))";

    private static Filter createFilter(BundleContext context) {
        try {
            return context.createFilter(FILTER_ADMIN_HTTP_SERVICE);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("error in implementation: " + (Object)((Object)e));
        }
    }

    public AdminUiHttpServiceTracker(BundleContext context) {
        super(context, AdminUiHttpServiceTracker.createFilter(context), null);
    }

    public HttpService addingService(ServiceReference<HttpService> reference) {
        HttpService httpService = (HttpService)super.addingService(reference);
        if (httpService == null) {
            return null;
        }
        AdminRootServlet rootServlet = new AdminRootServlet();
        try {
            httpService.registerServlet(ROOT_ALIAS, (Servlet)rootServlet, null, null);
        }
        catch (Exception e) {
            LOG.error("An error occurred while registering the root servlet. {}", (Object)e.getMessage(), (Object)e);
        }
        return httpService;
    }

    public void removedService(ServiceReference<HttpService> reference, HttpService service) {
        HttpService httpService = service;
        httpService.unregister(ROOT_ALIAS);
        super.removedService(reference, (Object)service);
    }

    private static final class AdminRootServlet
    extends HttpServlet {
        private static final long serialVersionUID = -7985169474502980696L;

        private AdminRootServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && !pathInfo.equals(AdminUiHttpServiceTracker.ROOT_ALIAS)) {
                resp.sendError(404, "Page Not Found");
                return;
            }
            resp.sendRedirect(String.valueOf(req.getContextPath()) + "/admin");
        }
    }
}

