/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal;

import org.eclipse.gyrex.admin.ui.configuration.ICreationHelper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DefaultCreationHelper
implements ICreationHelper {
    FormToolkit toolkit;

    public DefaultCreationHelper(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public static ICreationHelper create(FormToolkit toolkit) {
        return new DefaultCreationHelper(toolkit);
    }

    @Override
    public Composite createSection(Composite parent, String title, String description, int style, ScrolledForm form) {
        return this.createSection(parent, title, description, style, form, 1);
    }

    @Override
    public Composite createSection(Composite parent, String title, String description, int style, final ScrolledForm form, int numColumns) {
        if (style == -1) {
            style = 322;
        }
        Section section = this.toolkit.createSection(parent, style | (description != null ? 128 : 0));
        section.setText(title);
        section.setDescription(description);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        section.setLayoutData((Object)this.createGridData(parent));
        Composite panel = this.toolkit.createComposite((Composite)section);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = false;
        panel.setLayout((Layout)layout);
        section.setClient((Control)panel);
        return panel;
    }

    protected GridData createGridData(Composite parent) {
        Layout layout = parent.getLayout();
        int hSpan = 1;
        if (layout != null && layout instanceof GridLayout) {
            hSpan = ((GridLayout)layout).numColumns;
        }
        GridData data = new GridData(768);
        data.horizontalSpan = hSpan;
        return data;
    }

    protected TableWrapData createTableWrapData(Composite parent) {
        Layout layout = parent.getLayout();
        int hSpan = 1;
        if (layout != null && layout instanceof GridLayout) {
            hSpan = ((GridLayout)layout).numColumns;
        }
        TableWrapData data = new TableWrapData(256, 16, 1, hSpan);
        return data;
    }

    protected TableWrapData createTableWrapData(Composite parent, boolean grab) {
        Layout layout = parent.getLayout();
        int hSpan = 1;
        if (layout != null && layout instanceof GridLayout) {
            hSpan = ((GridLayout)layout).numColumns;
        }
        TableWrapData data = new TableWrapData(grab ? 256 : 128, 16, 1, hSpan);
        return data;
    }

    @Override
    public Button createButton(Composite parent, String text, int style) {
        return this.toolkit.createButton(parent, text, style);
    }

    @Override
    public CCombo createCombo(Composite parent, String[] options) {
        CCombo combo = new CCombo(parent, 0x800808);
        TableWrapData data = this.createTableWrapData(parent);
        data.maxWidth = 250;
        combo.setLayoutData((Object)data);
        combo.setItems(options);
        this.toolkit.adapt((Control)combo, true, true);
        return combo;
    }

    @Override
    public Label createDefaultLabel(Composite parent, String text) {
        Label label = this.toolkit.createLabel(parent, text, 16448);
        label.setLayoutData((Object)this.createTableWrapData(parent));
        return label;
    }

    @Override
    public Text createMultilineText(Composite parent, String text) {
        Text t = this.toolkit.createText(parent, text, 2626);
        TableWrapData d = this.createTableWrapData(parent);
        d.heightHint = t.getLineHeight() * 3 + 10;
        d.maxWidth = 250;
        t.setLayoutData((Object)d);
        return t;
    }

    @Override
    public Text createSinglelineText(Composite parent, String text) {
        Text t = this.toolkit.createText(parent, text);
        TableWrapData data = this.createTableWrapData(parent);
        data.maxWidth = 250;
        t.setLayoutData((Object)data);
        return t;
    }

    @Override
    public CCombo createCombo(Composite parent, String[] options, int style) {
        CCombo combo = new CCombo(parent, style);
        TableWrapData data = this.createTableWrapData(parent);
        data.maxWidth = 250;
        combo.setLayoutData((Object)data);
        combo.setItems(options);
        this.toolkit.adapt((Control)combo, true, true);
        return combo;
    }

    @Override
    public Composite createComposite(Composite parent) {
        Composite p = this.toolkit.createComposite(parent);
        p.setLayoutData((Object)this.createTableWrapData(parent));
        return p;
    }
}

