/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.configuration;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.admin.ui.internal.configuration.GeneralPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class PlatformStatusSection
extends SectionPart {
    private ServiceTracker<IStatus, IStatus> statusTracker;
    private FormText statusText;
    private final CopyOnWriteArrayList<IStatus> statusList = new CopyOnWriteArrayList();

    private static void addStatus(StringBuilder text, IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                PlatformStatusSection.addStatus(text, childStatus);
                ++n2;
            }
            return;
        }
        text.append("<li style=\"image\" value=\"");
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                text.append("IMG_OBJS_ERROR_TSK");
                break;
            }
            case 2: {
                text.append("IMG_OBJS_WARN_TSK");
                break;
            }
            case 1: {
                text.append("IMG_OBJS_INFO_TSK");
                break;
            }
        }
        text.append("\">").append(status.getMessage()).append("<br/>");
        text.append("(").append(status.getPlugin()).append(", code ").append(status.getCode()).append(")");
        text.append("</li>");
    }

    public PlatformStatusSection(Composite parent, GeneralPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.createContent(this.getSection(), page.getManagedForm().getToolkit());
    }

    private void createContent(Section section, FormToolkit toolkit) {
        section.setText("System Status");
        section.setDescription("This section describes the status of the system.");
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new TableWrapLayout());
        section.setClient((Control)client);
        this.statusText = toolkit.createFormText(client, false);
        this.statusText.setImage("IMG_OBJS_ERROR_TSK", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        this.statusText.setImage("IMG_OBJS_WARN_TSK", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.statusText.setImage("IMG_OBJS_INFO_TSK", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
    }

    public void dispose() {
        super.dispose();
        this.statusTracker.close();
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        BundleContext context = AdminUiActivator.getInstance().getBundle().getBundleContext();
        this.statusTracker = new ServiceTracker<IStatus, IStatus>(context, IStatus.class, null){

            public IStatus addingService(ServiceReference<IStatus> reference) {
                IStatus status = (IStatus)super.addingService(reference);
                if (status != null) {
                    PlatformStatusSection.this.statusList.add(status);
                    PlatformStatusSection.this.markStale();
                }
                return status;
            }

            public void modifiedService(ServiceReference<IStatus> reference, IStatus service) {
                PlatformStatusSection.this.markStale();
            }

            public void removedService(ServiceReference<IStatus> reference, IStatus service) {
                PlatformStatusSection.this.statusList.remove(service);
                PlatformStatusSection.this.markStale();
                super.removedService(reference, (Object)service);
            }
        };
        this.statusTracker.open();
    }

    public void refresh() {
        MultiStatus systemStatus = new MultiStatus("org.eclipse.gyrex.admin.ui", 0, "System Status", null);
        for (IStatus status : this.statusList) {
            systemStatus.add(status);
        }
        StringBuilder text = new StringBuilder();
        text.append("<text>");
        if (systemStatus.isOK()) {
            text.append("Your sytem is running fine.");
        } else {
            PlatformStatusSection.addStatus(text, (IStatus)systemStatus);
        }
        text.append("</text>");
        this.statusText.setText(text.toString(), true, true);
        super.refresh();
    }
}

