/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.gyrex.admin.ui.internal.helper.UiUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringDialogField
extends DialogField {
    private String fText = "";
    private Text fTextControl;
    private ModifyListener fModifyListener;
    private IContentProposalProvider fContentProposalProcessor;

    protected static GridData gridDataForText(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    protected Text createTextControl(Composite parent) {
        return new Text(parent, 2052);
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)StringDialogField.gridDataForText(nColumns - 1));
        return new Control[]{label, text};
    }

    private void doModifyText() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fText = this.fTextControl.getText();
        }
        this.dialogFieldChanged();
    }

    public IContentProposalProvider getContentProposalProcessor() {
        return this.fContentProposalProcessor;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public String getText() {
        return this.fText;
    }

    public Text getTextControl(Composite parent) {
        if (this.fTextControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringDialogField.this.doModifyText();
                }
            };
            this.fTextControl = this.createTextControl(parent);
            this.fTextControl.setText(this.fText);
            this.fTextControl.setFont(parent.getFont());
            this.fTextControl.addModifyListener(this.fModifyListener);
            this.fTextControl.setEnabled(this.isEnabled());
            if (this.fContentProposalProcessor != null) {
                UiUtil.addContentProposalBehavior(this.fTextControl, this.fContentProposalProcessor);
            }
        }
        return this.fTextControl;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
    }

    public void setContentProposalProcessor(IContentProposalProvider processor) {
        this.fContentProposalProcessor = processor;
        if (this.fContentProposalProcessor != null && this.isOkToUse((Control)this.fTextControl)) {
            UiUtil.addContentProposalBehavior(this.fTextControl, this.fContentProposalProcessor);
        }
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setFocus();
            this.fTextControl.setSelection(0, this.fTextControl.getText().length());
        }
        return true;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.removeModifyListener(this.fModifyListener);
            this.fTextControl.setText(text);
            this.fTextControl.addModifyListener(this.fModifyListener);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }
}

