/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IUploadAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rwt.widgets.Upload;
import org.eclipse.rwt.widgets.UploadAdapter;
import org.eclipse.rwt.widgets.UploadEvent;
import org.eclipse.rwt.widgets.UploadListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class UploadDialogField
extends DialogField {
    private String uploadPath;
    private String browseButtonLabel;
    private String uploadButtonLabel;
    private Upload uploadControl;
    private ModifyListener modifyListener;
    private final IUploadAdapter uploadAdapter;

    protected static GridData gridDataForUpload(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public UploadDialogField(IUploadAdapter uploadAdapter) {
        this.uploadAdapter = uploadAdapter;
        this.browseButtonLabel = "Browse...";
        this.uploadButtonLabel = "Upload";
        this.uploadPath = "";
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)UploadDialogField.gridDataForLabel(1));
        Upload upload = this.getUploadControl(parent);
        upload.setLayoutData((Object)UploadDialogField.gridDataForUpload(nColumns - 1));
        return new Control[]{label, upload};
    }

    private void doModifyUploadPath() {
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadPath = this.uploadControl.getPath();
        }
        this.dialogFieldChanged();
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public Upload getUploadControl(final Composite parent) {
        if (this.uploadControl == null) {
            this.assertCompositeNotNull(parent);
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    UploadDialogField.this.doModifyUploadPath();
                }
            };
            this.uploadControl = new Upload(parent, 2048, 3);
            this.uploadControl.setBrowseButtonText(this.browseButtonLabel);
            this.uploadControl.setUploadButtonText(this.uploadButtonLabel);
            this.uploadControl.setFont(parent.getFont());
            this.uploadControl.addModifyListener(this.modifyListener);
            this.uploadControl.addUploadListener((UploadListener)new UploadAdapter(){

                public void uploadException(UploadEvent uploadEvent) {
                    Exception exc = uploadEvent.getUploadException();
                    if (exc != null) {
                        MessageDialog.openError((Shell)SwtUtil.getShell((Widget)parent), (String)"Upload Error", (String)exc.getMessage());
                    }
                }

                public void uploadFinished(UploadEvent uploadEvent) {
                    UploadDialogField.this.uploadAdapter.uploadFinished(UploadDialogField.this.uploadControl.getUploadItem());
                }
            });
            this.uploadControl.setEnabled(this.isEnabled());
        }
        return this.uploadControl;
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.isOkToUse((Control)this.uploadControl);
    }

    public void setBrowseButtonLabel(String browseButtonLabel) {
        this.browseButtonLabel = browseButtonLabel;
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setBrowseButtonText(browseButtonLabel);
        }
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setFocus();
        }
        return true;
    }

    public void setUploadButtonLabel(String uploadButtonLabel) {
        this.uploadButtonLabel = uploadButtonLabel;
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setUploadButtonText(uploadButtonLabel);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setEnabled(this.isEnabled());
        }
    }
}

