/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.sliderkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Widget;

public class SliderLCA
extends AbstractWidgetLCA {
    static final String PROP_SELECTION = "selection";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_THUMB = "thumb";
    static final Integer DEFAULT_SELECTION = new Integer(0);
    static final Integer DEFAULT_MAXIMUM = new Integer(100);
    static final Integer DEFAULT_MINIMUM = new Integer(0);
    static final Integer DEFAULT_PAGE_INCREMENT = new Integer(10);
    static final Integer DEFAULT_INCREMENT = new Integer(1);
    static final Integer DEFAULT_THUMB = new Integer(10);

    public void preserveValues(Widget widget) {
        Slider slider = (Slider)widget;
        ControlLCAUtil.preserveValues((Control)slider);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)slider);
        boolean hasListeners = SelectionEvent.hasListener((Adaptable)slider);
        adapter.preserve("selectionListeners", (Object)hasListeners);
        adapter.preserve(PROP_SELECTION, (Object)new Integer(slider.getSelection()));
        adapter.preserve(PROP_MAXIMUM, (Object)new Integer(slider.getMaximum()));
        adapter.preserve(PROP_MINIMUM, (Object)new Integer(slider.getMinimum()));
        adapter.preserve(PROP_PAGE_INCREMENT, (Object)new Integer(slider.getPageIncrement()));
        adapter.preserve(PROP_INCREMENT, (Object)new Integer(slider.getIncrement()));
        adapter.preserve(PROP_THUMB, (Object)new Integer(slider.getThumb()));
    }

    public void readData(Widget widget) {
        Slider slider = (Slider)widget;
        String value = WidgetLCAUtil.readPropertyValue((Widget)slider, PROP_SELECTION);
        if (value != null) {
            slider.setSelection(NumberFormatUtil.parseInt((String)value));
        }
        ControlLCAUtil.processSelection((Widget)slider, null, true);
        ControlLCAUtil.processMenuDetect((Control)slider);
        WidgetLCAUtil.processHelp((Widget)slider);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Slider slider = (Slider)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)slider);
        String style = "";
        style = (slider.getStyle() & 0x100) != 0 ? "horizontal" : "vertical";
        Object[] args = new Object[]{style};
        writer.newWidget("org.eclipse.swt.widgets.Slider", args);
        WidgetLCAUtil.writeCustomVariant(widget);
        ControlLCAUtil.writeStyleFlags((Control)slider);
    }

    public void renderChanges(Widget widget) throws IOException {
        Slider slider = (Slider)widget;
        ControlLCAUtil.writeChanges((Control)slider);
        this.writeMaximum(slider);
        this.writeMinimum(slider);
        this.writePageIncrement(slider);
        this.writeSelection(slider);
        this.writeIncrement(slider);
        this.writeThumb(slider);
        this.writeListener(slider);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private void writeMaximum(Slider slider) throws IOException {
        Integer newValue = new Integer(slider.getMaximum());
        if (WidgetLCAUtil.hasChanged((Widget)slider, PROP_MAXIMUM, newValue, DEFAULT_MAXIMUM)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)slider);
            writer.set(PROP_MAXIMUM, newValue);
        }
    }

    private void writeMinimum(Slider slider) throws IOException {
        Integer defValue;
        String prop = PROP_MINIMUM;
        Integer newValue = new Integer(slider.getMinimum());
        if (WidgetLCAUtil.hasChanged((Widget)slider, prop, newValue, defValue = DEFAULT_MINIMUM)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)slider);
            writer.set(PROP_MINIMUM, newValue);
        }
    }

    private void writeSelection(Slider slider) throws IOException {
        Integer defValue;
        String prop = PROP_SELECTION;
        Integer newValue = new Integer(slider.getSelection());
        if (WidgetLCAUtil.hasChanged((Widget)slider, prop, newValue, defValue = DEFAULT_SELECTION)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)slider);
            writer.set(PROP_SELECTION, newValue);
        }
    }

    private void writeIncrement(Slider slider) throws IOException {
        Integer defValue;
        String prop = PROP_INCREMENT;
        Integer newValue = new Integer(slider.getIncrement());
        if (WidgetLCAUtil.hasChanged((Widget)slider, prop, newValue, defValue = DEFAULT_INCREMENT)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)slider);
            writer.set(PROP_INCREMENT, newValue);
        }
    }

    private void writePageIncrement(Slider slider) throws IOException {
        Integer defValue;
        String prop = PROP_PAGE_INCREMENT;
        Integer newValue = new Integer(slider.getPageIncrement());
        if (WidgetLCAUtil.hasChanged((Widget)slider, prop, newValue, defValue = DEFAULT_PAGE_INCREMENT)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)slider);
            writer.set(PROP_PAGE_INCREMENT, newValue);
        }
    }

    private void writeThumb(Slider slider) throws IOException {
        Integer defValue;
        String prop = PROP_THUMB;
        Integer newValue = new Integer(slider.getThumb());
        if (WidgetLCAUtil.hasChanged((Widget)slider, prop, newValue, defValue = DEFAULT_THUMB)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)slider);
            writer.set(PROP_THUMB, newValue);
        }
    }

    private void writeListener(Slider slider) throws IOException {
        String prop = "selectionListeners";
        boolean hasListener = SelectionEvent.hasListener((Adaptable)slider);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)slider, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)slider);
            writer.set("hasSelectionListener", newValue);
        }
    }
}

