/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryImpl;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;

public class JobHistoryStore {
    private static final String NODE_HISTORY = "history";
    private static final String NODE_JOBS = "jobs";

    public static JobHistoryImpl create(String jobStorageKey, String jobId, IRuntimeContext context) throws BackingStoreException {
        IEclipsePreferences historyNode = JobHistoryStore.getHistoryNode(jobStorageKey);
        JobHistoryImpl jobHistoryImpl = new JobHistoryImpl(jobId, context.getContextPath());
        jobHistoryImpl.load(historyNode);
        return jobHistoryImpl;
    }

    public static void flush(String jobStorageKey, JobHistoryImpl history) throws BackingStoreException {
        IEclipsePreferences historyNode = JobHistoryStore.getHistoryNode(jobStorageKey);
        history.save(historyNode);
        historyNode.flush();
    }

    static IEclipsePreferences getHistoryNode(String jobStorageKey) throws BackingStoreException {
        IEclipsePreferences jobsNode = JobHistoryStore.getJobsNode();
        if (!jobsNode.nodeExists(jobStorageKey)) {
            throw new BackingStoreException(String.format("Job node '%s' not found!", jobStorageKey));
        }
        return (IEclipsePreferences)jobsNode.node(jobStorageKey).node(NODE_HISTORY);
    }

    static IEclipsePreferences getJobsNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node(NODE_JOBS);
    }
}

