/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.JobState;

public class JobImpl
implements IJob {
    private String id;
    private String typeId;
    private Map<String, String> parameter;
    private long lastStart = -1L;
    private long lastSuccessfulFinish = -1L;
    private JobState state;
    private long lastResultTimestamp;
    private IStatus lastResult;

    @Override
    public String getId() {
        return this.id;
    }

    public IStatus getLastResult() {
        return this.lastResult;
    }

    public long getLastResultTimestamp() {
        return this.lastResultTimestamp;
    }

    @Override
    public long getLastStart() {
        return this.lastStart;
    }

    @Override
    public long getLastSuccessfulFinish() {
        return this.lastSuccessfulFinish;
    }

    @Override
    public Map<String, String> getParameter() {
        return Collections.unmodifiableMap(this.parameter);
    }

    @Override
    public JobState getState() {
        if (this.state == null) {
            throw new IllegalStateException("status must not be null");
        }
        return this.state;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLastResult(long timestamp, int severity, String message) {
        this.lastResultTimestamp = timestamp;
        try {
            this.lastResult = new Status(severity, "org.eclipse.gyrex.jobs", message);
        }
        catch (Exception e) {
            this.lastResult = new Status(8, "org.eclipse.gyrex.jobs", String.format("Error reading result. %s", e.getMessage()));
        }
    }

    public void setLastStart(long lastStart) {
        this.lastStart = lastStart;
    }

    public void setLastSuccessfulFinish(long lastSuccessfullFinish) {
        this.lastSuccessfulFinish = lastSuccessfullFinish;
    }

    public void setParameter(Map<String, String> parameter) {
        this.parameter = parameter;
    }

    public void setStatus(JobState status) {
        this.state = status;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }
}

