/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.registry.JobProviderRegistry;
import org.eclipse.gyrex.jobs.internal.registry.RegistryJobProvider;
import org.eclipse.gyrex.jobs.provider.JobProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobProviderExtensionReader
implements IExtensionChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JobProviderExtensionReader.class);
    private final ExtensionTracker extensionTracker;
    private final JobProviderRegistry providerRegistry;

    public JobProviderExtensionReader(JobProviderRegistry providerRegistry, IExtensionRegistry extensionRegistry) {
        this.providerRegistry = providerRegistry;
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.gyrex.jobs.providers");
        if (extensionPoint == null) {
            throw new IllegalStateException("providers extension point not found; please check bundle deployment");
        }
        this.extensionTracker = new ExtensionTracker(extensionRegistry);
        this.extensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extensionPoint));
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension((IExtensionTracker)this.extensionTracker, extension);
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("job".equals(element.getName())) {
                String id = element.getAttribute("id");
                if (!IdHelper.isValidId((String)id)) {
                    LOG.warn("Invalid id {} found in job provider extension contributed by {}", new Object[]{id, extension.getContributor().getName()});
                } else {
                    RegistryJobProvider provider = new RegistryJobProvider(id, element);
                    tracker.registerObject(extension, (Object)provider, 0);
                    this.providerRegistry.addJobProvider(provider);
                }
            }
            ++n2;
        }
    }

    public void close() {
        this.extensionTracker.close();
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof RegistryJobProvider) {
                this.providerRegistry.removeJobProvider((JobProvider)((Object)object));
            }
            ++n2;
        }
    }
}

