/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.manager.IJobStateWatch;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.gyrex.jobs.internal.worker.JobContext;
import org.eclipse.gyrex.jobs.manager.IJobManager;

public final class JobStateSynchronizer
implements IJobChangeListener,
IJobStateWatch {
    private final Job realJob;
    private final JobContext jobContext;

    public JobStateSynchronizer(Job realJob, JobContext jobContext) {
        this.realJob = realJob;
        this.jobContext = jobContext;
    }

    public void aboutToRun(IJobChangeEvent event) {
        String jobId;
        JobManagerImpl jobManager = this.getJobManager();
        JobImpl job = jobManager.getJob(jobId = this.getJobId());
        if (job.getState() != JobState.WAITING) {
            this.cancelRealJob();
        }
    }

    public void awake(IJobChangeEvent event) {
    }

    private void cancelRealJob() {
        if (this.realJob.cancel()) {
            this.getJobManager().setJobState(this.getJobId(), JobState.ABORTING, JobState.NONE, null);
        }
    }

    public void done(IJobChangeEvent event) {
        JobManagerImpl jobManager = this.getJobManager();
        jobManager.setJobState(this.getJobId(), null, JobState.NONE, null);
        jobManager.setResult(this.getJobId(), event.getResult(), System.currentTimeMillis());
    }

    private String getJobId() {
        return this.jobContext.getJobId();
    }

    JobManagerImpl getJobManager() {
        return (JobManagerImpl)this.jobContext.getContext().get(IJobManager.class);
    }

    @Override
    public void jobStateChanged(String jobId) {
        JobImpl job = this.getJobManager().getJob(this.getJobId());
        JobState state = job.getState();
        if (state == JobState.ABORTING) {
            this.cancelRealJob();
        }
    }

    public void running(IJobChangeEvent event) {
        JobManagerImpl jobManager = this.getJobManager();
        jobManager.setJobState(this.getJobId(), JobState.WAITING, JobState.RUNNING, this);
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

