/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.StatementCacheInteractor;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.am.stmtcache.StatementKey;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class LogicalStatementEntity
implements Statement {
    private final boolean hasCallableStmt;
    private java.sql.PreparedStatement physicalPs;
    private java.sql.CallableStatement physicalCs;
    private StatementCacheInteractor owner;
    private final StatementKey stmtKey;
    private final JDBCStatementCache cache;

    protected LogicalStatementEntity(java.sql.PreparedStatement physicalPs, StatementKey stmtKey, StatementCacheInteractor cacheInteractor) {
        if (cacheInteractor.getCache() == null) {
            throw new IllegalArgumentException("statement cache reference cannot be <null>");
        }
        this.stmtKey = stmtKey;
        this.cache = cacheInteractor.getCache();
        this.owner = cacheInteractor;
        this.physicalPs = physicalPs;
        if (physicalPs instanceof CallableStatement) {
            this.hasCallableStmt = true;
            this.physicalCs = (CallableStatement)physicalPs;
        } else {
            this.hasCallableStmt = false;
            this.physicalCs = null;
        }
        ((PreparedStatement)physicalPs).setOwner(this);
    }

    synchronized java.sql.PreparedStatement getPhysPs() throws SQLException {
        if (this.physicalPs == null) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), "PreparedStatement").getSQLException();
        }
        return this.physicalPs;
    }

    synchronized java.sql.CallableStatement getPhysCs() throws SQLException {
        SanityManager.ASSERT(this.hasCallableStmt, "called getPhysCs(), but created with PreparedStatement");
        if (this.physicalCs == null) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), "CallableStatement").getSQLException();
        }
        return this.physicalCs;
    }

    public synchronized void close() throws SQLException {
        if (this.physicalPs != null) {
            PreparedStatement temporaryPsRef = (PreparedStatement)this.physicalPs;
            this.physicalPs = null;
            this.physicalCs = null;
            this.owner.markClosed(this);
            this.owner = null;
            temporaryPsRef.setOwner(null);
            if (temporaryPsRef.isClosed()) {
                return;
            }
            try {
                temporaryPsRef.resetForReuse();
            }
            catch (SqlException sqle) {
                throw sqle.getSQLException();
            }
            if (!this.cache.cacheStatement(this.stmtKey, temporaryPsRef)) {
                temporaryPsRef.close();
            }
        }
    }

    synchronized boolean isLogicalEntityClosed() {
        return this.physicalPs == null;
    }
}

