/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.sql.Array;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.FailedProperties40;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.jdbc.ClientBaseDataSource;

public class NetConnection40
extends NetConnection {
    private PreparedStatement isValidStmt = null;

    public NetConnection40(NetLogWriter netLogWriter, String databaseName, Properties properties) throws SqlException {
        super(netLogWriter, databaseName, properties);
    }

    public NetConnection40(NetLogWriter netLogWriter, ClientBaseDataSource dataSource, String user, String password) throws SqlException {
        super(netLogWriter, dataSource, user, password);
    }

    public NetConnection40(NetLogWriter netLogWriter, int driverManagerLoginTimeout, String serverName, int portNumber, String databaseName, Properties properties) throws SqlException {
        super(netLogWriter, driverManagerLoginTimeout, serverName, portNumber, databaseName, properties);
    }

    public NetConnection40(NetLogWriter netLogWriter, String user, String password, ClientBaseDataSource dataSource, int rmId, boolean isXAConn) throws SqlException {
        super(netLogWriter, user, password, dataSource, rmId, isXAConn);
    }

    public NetConnection40(NetLogWriter netLogWriter, String ipaddr, int portNumber, ClientBaseDataSource dataSource, boolean isXAConn) throws SqlException {
        super(netLogWriter, ipaddr, portNumber, dataSource, isXAConn);
    }

    public NetConnection40(NetLogWriter netLogWriter, String user, String password, ClientBaseDataSource dataSource, int rmId, boolean isXAConn, ClientPooledConnection cpc) throws SqlException {
        super(netLogWriter, user, password, dataSource, rmId, isXAConn, cpc);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLExceptionFactory.notImplemented("createArrayOf(String,Object[])");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SQLExceptionFactory.notImplemented("createNClob ()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SQLExceptionFactory.notImplemented("createSQLXML ()");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLExceptionFactory.notImplemented("createStruct(String,Object[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(timeout), (Object)"timeout", "java.sql.Connection.isValid").getSQLException();
        }
        if (this.isClosed()) {
            return false;
        }
        NetConnection40 netConnection40 = this;
        synchronized (netConnection40) {
            try {
                int oldTimeout = this.netAgent_.getTimeout();
                this.netAgent_.setTimeout(timeout);
                if (this.isValidStmt == null) {
                    this.isValidStmt = this.prepareStatement("VALUES (1)");
                }
                this.isValidStmt.setQueryTimeout(timeout);
                ResultSet rs = this.isValidStmt.executeQuery();
                rs.close();
                this.netAgent_.setTimeout(oldTimeout);
            }
            catch (SQLException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isValidStmt != null) {
            this.isValidStmt.close();
            this.isValidStmt = null;
        }
        super.close();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties p = FailedProperties40.makeProperties(name, value);
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), new FailedProperties40(p).getProperties());
        }
        if (name == null && value == null) {
            return;
        }
        this.setClientInfo(p);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        FailedProperties40 fp = new FailedProperties40(properties);
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), fp.getProperties());
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        SqlException se = new SqlException(this.agent_.logWriter_, new ClientMessageId("XCY02.S"), (Object)fp.getFirstKey(), fp.getFirstValue());
        throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), fp.getProperties());
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            this.checkForClosedConnection();
            return null;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.checkForClosedConnection();
            return new Properties();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        Map typeMap = super.getTypeMap();
        if (typeMap == null) {
            return null;
        }
        HashMap genericTypeMap = new HashMap();
        for (Object key : typeMap.keySet()) {
            genericTypeMap.put((String)key, (Class)typeMap.get(key));
        }
        return genericTypeMap;
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return interfaces.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        try {
            this.checkForClosedConnection();
            return interfaces.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), interfaces).getSQLException();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }
}

