/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;

public abstract class BrokeredPreparedStatement
extends BrokeredStatement
implements EnginePreparedStatement {
    final String sql;

    public BrokeredPreparedStatement(BrokeredStatementControl control, String sql) throws SQLException {
        super(control);
        this.sql = sql;
    }

    public final ResultSet executeQuery() throws SQLException {
        return this.wrapResultSet(this.getPreparedStatement().executeQuery());
    }

    public final int executeUpdate() throws SQLException {
        return this.getPreparedStatement().executeUpdate();
    }

    public final void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getPreparedStatement().setNull(parameterIndex, sqlType);
    }

    public final void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getPreparedStatement().setNull(parameterIndex, sqlType, typeName);
    }

    public final void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getPreparedStatement().setBoolean(parameterIndex, x);
    }

    public final void setByte(int parameterIndex, byte x) throws SQLException {
        this.getPreparedStatement().setByte(parameterIndex, x);
    }

    public final void setShort(int parameterIndex, short x) throws SQLException {
        this.getPreparedStatement().setShort(parameterIndex, x);
    }

    public final void setInt(int parameterIndex, int x) throws SQLException {
        this.getPreparedStatement().setInt(parameterIndex, x);
    }

    public final void setLong(int parameterIndex, long x) throws SQLException {
        this.getPreparedStatement().setLong(parameterIndex, x);
    }

    public final void setFloat(int parameterIndex, float x) throws SQLException {
        this.getPreparedStatement().setFloat(parameterIndex, x);
    }

    public final void setDouble(int parameterIndex, double x) throws SQLException {
        this.getPreparedStatement().setDouble(parameterIndex, x);
    }

    public final void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getPreparedStatement().setBigDecimal(parameterIndex, x);
    }

    public final void setString(int parameterIndex, String x) throws SQLException {
        this.getPreparedStatement().setString(parameterIndex, x);
    }

    public final void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getPreparedStatement().setBytes(parameterIndex, x);
    }

    public final void setDate(int parameterIndex, Date x) throws SQLException {
        this.getPreparedStatement().setDate(parameterIndex, x);
    }

    public final void setTime(int parameterIndex, Time x) throws SQLException {
        this.getPreparedStatement().setTime(parameterIndex, x);
    }

    public final void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getPreparedStatement().setTimestamp(parameterIndex, x);
    }

    public final void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getPreparedStatement().setAsciiStream(parameterIndex, x, length);
    }

    public final void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getPreparedStatement().setUnicodeStream(parameterIndex, x, length);
    }

    public final void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getPreparedStatement().setBinaryStream(parameterIndex, x, length);
    }

    public final void addBatch() throws SQLException {
        this.getPreparedStatement().addBatch();
    }

    public final void clearParameters() throws SQLException {
        this.getPreparedStatement().clearParameters();
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.getPreparedStatement().getMetaData();
    }

    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.getPreparedStatement().setObject(parameterIndex, x, targetSqlType, scale);
    }

    public final void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getPreparedStatement().setObject(parameterIndex, x, targetSqlType);
    }

    public final void setObject(int parameterIndex, Object x) throws SQLException {
        this.getPreparedStatement().setObject(parameterIndex, x);
    }

    public final boolean execute() throws SQLException {
        return this.getPreparedStatement().execute();
    }

    public final void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getPreparedStatement().setCharacterStream(parameterIndex, reader, length);
    }

    public final void setRef(int i, Ref x) throws SQLException {
        this.getPreparedStatement().setRef(i, x);
    }

    public final void setBlob(int i, Blob x) throws SQLException {
        this.getPreparedStatement().setBlob(i, x);
    }

    public final void setClob(int i, Clob x) throws SQLException {
        this.getPreparedStatement().setClob(i, x);
    }

    public final void setArray(int i, Array x) throws SQLException {
        this.getPreparedStatement().setArray(i, x);
    }

    public final void setDate(int i, Date x, Calendar cal) throws SQLException {
        this.getPreparedStatement().setDate(i, x, cal);
    }

    public final void setTime(int i, Time x, Calendar cal) throws SQLException {
        this.getPreparedStatement().setTime(i, x, cal);
    }

    public final void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        this.getPreparedStatement().setTimestamp(i, x, cal);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        EnginePreparedStatement engnps = (EnginePreparedStatement)this.getPreparedStatement();
        engnps.setBinaryStream(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        EnginePreparedStatement engnps = (EnginePreparedStatement)this.getPreparedStatement();
        engnps.setCharacterStream(parameterIndex, reader);
    }

    PreparedStatement getPreparedStatement() throws SQLException {
        return this.control.getRealPreparedStatement();
    }

    public final Statement getStatement() throws SQLException {
        return this.getPreparedStatement();
    }

    public PreparedStatement createDuplicateStatement(Connection conn, PreparedStatement oldStatement) throws SQLException {
        PreparedStatement newStatement = conn.prepareStatement(this.sql, this.resultSetType, this.resultSetConcurrency);
        this.setStatementState(oldStatement, newStatement);
        return newStatement;
    }
}

