/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class ForeignKeyConstraintDescriptor
extends KeyConstraintDescriptor {
    ReferencedKeyConstraintDescriptor referencedConstraintDescriptor;
    UUID referencedConstraintId;
    int raDeleteRule;
    int raUpdateRule;

    protected ForeignKeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] fkColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, ReferencedKeyConstraintDescriptor referencedConstraintDescriptor, boolean isEnabled, int raDeleteRule, int raUpdateRule) {
        super(dataDictionary, table, constraintName, deferrable, initiallyDeferred, fkColumns, constraintId, indexId, schemaDesc, isEnabled);
        this.referencedConstraintDescriptor = referencedConstraintDescriptor;
        this.raDeleteRule = raDeleteRule;
        this.raUpdateRule = raUpdateRule;
    }

    ForeignKeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] fkColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, UUID referencedConstraintId, boolean isEnabled, int raDeleteRule, int raUpdateRule) {
        super(dataDictionary, table, constraintName, deferrable, initiallyDeferred, fkColumns, constraintId, indexId, schemaDesc, isEnabled);
        this.referencedConstraintId = referencedConstraintId;
        this.raDeleteRule = raDeleteRule;
        this.raUpdateRule = raUpdateRule;
    }

    public ReferencedKeyConstraintDescriptor getReferencedConstraint() throws StandardException {
        TableDescriptor refTd;
        if (this.referencedConstraintDescriptor != null) {
            return this.referencedConstraintDescriptor;
        }
        if (this.referencedConstraintId == null) {
            this.getReferencedConstraintId();
        }
        if ((refTd = this.getDataDictionary().getConstraintTableDescriptor(this.referencedConstraintId)) == null) {
            SanityManager.THROWASSERT("not able to find " + this.referencedConstraintId + " in SYS.SYSCONSTRAINTS");
        }
        ConstraintDescriptorList cdl = this.getDataDictionary().getConstraintDescriptors(refTd);
        this.referencedConstraintDescriptor = (ReferencedKeyConstraintDescriptor)cdl.getConstraintDescriptorById(this.referencedConstraintId);
        if (this.referencedConstraintDescriptor == null) {
            SanityManager.THROWASSERT("not able to find " + this.referencedConstraintDescriptor + " off of table descriptor " + refTd.getName());
        }
        return this.referencedConstraintDescriptor;
    }

    public UUID getReferencedConstraintId() throws StandardException {
        if (this.referencedConstraintDescriptor != null) {
            return this.referencedConstraintDescriptor.getUUID();
        }
        SubKeyConstraintDescriptor subKey = this.getDataDictionary().getSubKeyConstraint(this.constraintId, 6);
        if (subKey == null) {
            SanityManager.THROWASSERT("not able to find " + this.constraintName + " in SYS.SYSFOREIGNKEYS");
        }
        this.referencedConstraintId = subKey.getKeyConstraintId();
        return this.referencedConstraintId;
    }

    public int getConstraintType() {
        return 6;
    }

    public boolean needsToFire(int stmtType, int[] modifiedCols) {
        if (!this.isEnabled) {
            return false;
        }
        if (stmtType == 4) {
            return false;
        }
        if (stmtType == 1) {
            return true;
        }
        return ForeignKeyConstraintDescriptor.doColumnsIntersect(modifiedCols, this.getReferencedColumns());
    }

    public boolean isSelfReferencingFK() throws StandardException {
        ReferencedKeyConstraintDescriptor refcd = this.getReferencedConstraint();
        return refcd.getTableId().equals(this.getTableId());
    }

    public int getRaDeleteRule() {
        return this.raDeleteRule;
    }

    public int getRaUpdateRule() {
        return this.raUpdateRule;
    }
}

