/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;

public class RowUtil {
    public static final DataValueDescriptor[] EMPTY_ROW = new DataValueDescriptor[0];
    public static final FormatableBitSet EMPTY_ROW_BITSET = new FormatableBitSet(0);
    public static final FetchDescriptor EMPTY_ROW_FETCH_DESCRIPTOR = new FetchDescriptor(0);
    private static final FetchDescriptor[] ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS = new FetchDescriptor[]{EMPTY_ROW_FETCH_DESCRIPTOR, new FetchDescriptor(1, 1), new FetchDescriptor(2, 2), new FetchDescriptor(3, 3), new FetchDescriptor(4, 4), new FetchDescriptor(5, 5), new FetchDescriptor(6, 6), new FetchDescriptor(7, 7)};

    private RowUtil() {
    }

    public static DataValueDescriptor getColumn(DataValueDescriptor[] row, FormatableBitSet columnList, int columnId) {
        if (columnList == null) {
            return columnId < row.length ? row[columnId] : null;
        }
        if (columnList.getLength() <= columnId || !columnList.isSet(columnId)) {
            return null;
        }
        return columnId < row.length ? row[columnId] : null;
    }

    public static Object getColumn(Object[] row, FormatableBitSet columnList, int columnId) {
        if (columnList == null) {
            return columnId < row.length ? row[columnId] : null;
        }
        if (columnList.getLength() <= columnId || !columnList.isSet(columnId)) {
            return null;
        }
        return columnId < row.length ? row[columnId] : null;
    }

    public static FormatableBitSet getQualifierBitSet(Qualifier[][] qualifiers) {
        FormatableBitSet qualifierColumnList = new FormatableBitSet();
        if (qualifiers != null) {
            for (int i = 0; i < qualifiers.length; ++i) {
                for (int j = 0; j < qualifiers[i].length; ++j) {
                    int colId = qualifiers[i][j].getColumnId();
                    qualifierColumnList.grow(colId + 1);
                    qualifierColumnList.set(colId);
                }
            }
        }
        return qualifierColumnList;
    }

    public static int getNumberOfColumns(int maxColumnNumber, FormatableBitSet columnList) {
        SanityManager.ASSERT(columnList != null);
        int max_col_number = columnList.getLength();
        if (maxColumnNumber > 0 && maxColumnNumber < max_col_number) {
            max_col_number = maxColumnNumber;
        }
        int ret_num_cols = 0;
        for (int i = 0; i < max_col_number; ++i) {
            if (!columnList.isSet(i)) continue;
            ++ret_num_cols;
        }
        return ret_num_cols;
    }

    public static boolean isRowEmpty(DataValueDescriptor[] row) {
        if (row == null) {
            return true;
        }
        return row.length == 0;
    }

    public static int columnOutOfRange(DataValueDescriptor[] row, FormatableBitSet columnList, int maxColumns) {
        if (columnList == null) {
            if (row.length > maxColumns) {
                return maxColumns;
            }
            return -1;
        }
        int size = columnList.getLength();
        for (int i = maxColumns; i < size; ++i) {
            if (!columnList.isSet(i)) continue;
            return i;
        }
        return -1;
    }

    public static int nextColumn(Object[] row, FormatableBitSet columnList, int startColumn) {
        if (columnList != null) {
            int size = columnList.getLength();
            while (startColumn < size) {
                if (columnList.isSet(startColumn)) {
                    return startColumn;
                }
                ++startColumn;
            }
            return -1;
        }
        if (row == null) {
            return -1;
        }
        return startColumn < row.length ? startColumn : -1;
    }

    public static final FetchDescriptor getFetchDescriptorConstant(int single_column_number) {
        if (single_column_number < ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS.length) {
            return ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS[single_column_number];
        }
        return new FetchDescriptor(single_column_number, single_column_number);
    }

    public static DataValueDescriptor[] newTemplate(DataValueFactory dvf, FormatableBitSet column_list, int[] format_ids, int[] collation_ids) throws StandardException {
        int num_cols = format_ids.length;
        DataValueDescriptor[] ret_row = new DataValueDescriptor[num_cols];
        int column_listSize = column_list == null ? 0 : column_list.getLength();
        for (int i = 0; i < num_cols; ++i) {
            if (column_list != null && (column_listSize <= i || !column_list.isSet(i))) continue;
            ret_row[i] = dvf.getNull(format_ids[i], collation_ids[i]);
        }
        return ret_row;
    }

    private static void newRowFromClassInfoTemplateError() {
        SanityManager.THROWASSERT("unexpected error in newRowFromClassInfoTemplate()");
    }

    public static DataValueDescriptor[] newRowFromTemplate(DataValueDescriptor[] template) throws StandardException {
        DataValueDescriptor[] columns = new DataValueDescriptor[template.length];
        int column_index = template.length;
        while (column_index-- > 0) {
            if (template[column_index] == null) continue;
            columns[column_index] = template[column_index].getNewNull();
        }
        return columns;
    }

    public static String toString(Object[] row) {
        String str = new String();
        if (row != null) {
            if (row.length == 0) {
                str = "empty row";
            } else {
                for (int i = 0; i < row.length; ++i) {
                    str = str + "col[" + i + "]=" + row[i];
                }
            }
        } else {
            str = "row is null";
        }
        return str;
    }

    public static String toString(Hashtable hash_table) {
        String str = new String();
        Enumeration e = hash_table.elements();
        while (e.hasMoreElements()) {
            Object row_or_vector = e.nextElement();
            if (row_or_vector instanceof Object[]) {
                str = str + RowUtil.toString((Object[])row_or_vector);
                str = str + "\n";
                continue;
            }
            if (row_or_vector instanceof Vector) {
                Vector vec = (Vector)row_or_vector;
                for (int i = 0; i < vec.size(); ++i) {
                    str = str + "vec[" + i + "]:" + RowUtil.toString((Object[])vec.elementAt(i));
                    str = str + "\n";
                }
                continue;
            }
            str = str + "BAD ENTRY\n";
        }
        return str;
    }

    public static final boolean qualifyRow(DataValueDescriptor[] row, Qualifier[][] qual_list) throws StandardException {
        boolean row_qualifies = true;
        SanityManager.ASSERT(row != null);
        SanityManager.ASSERT(qual_list != null);
        SanityManager.ASSERT(qual_list.length > 0);
        for (int i = 0; i < qual_list[0].length; ++i) {
            row_qualifies = false;
            Qualifier q = qual_list[0][i];
            DataValueDescriptor columnValue = row[q.getColumnId()];
            row_qualifies = columnValue.compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
            if (q.negateCompareResult()) {
                boolean bl = row_qualifies = !row_qualifies;
            }
            if (row_qualifies) continue;
            return false;
        }
        for (int and_idx = 1; and_idx < qual_list.length; ++and_idx) {
            row_qualifies = false;
            SanityManager.ASSERT(qual_list[and_idx].length > 0);
            for (int or_idx = 0; or_idx < qual_list[and_idx].length; ++or_idx) {
                Qualifier q = qual_list[and_idx][or_idx];
                int col_id = q.getColumnId();
                SanityManager.ASSERT(col_id < row.length, "Qualifier is referencing a column not in the row.");
                DataValueDescriptor columnValue = row[q.getColumnId()];
                if (columnValue == null) {
                    SanityManager.THROWASSERT("1:row = " + RowUtil.toString(row) + "row.length = " + row.length + ";q.getColumnId() = " + q.getColumnId());
                }
                row_qualifies = columnValue.compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
                if (q.negateCompareResult()) {
                    boolean bl = row_qualifies = !row_qualifies;
                }
                if (row_qualifies) break;
            }
            if (!row_qualifies) break;
        }
        return row_qualifies;
    }
}

