/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;

final class StandardEXTDTAReaderInputStream
extends EXTDTAReaderInputStream {
    private final long length;
    private final DDMReader reader;
    private long remainingBytes;
    private ByteArrayInputStream currentBuffer;

    StandardEXTDTAReaderInputStream(DDMReader reader) throws DRDAProtocolException {
        this.reader = reader;
        this.remainingBytes = this.length = reader.getDdmLength();
        this.currentBuffer = reader.readLOBInitStream(this.remainingBytes);
    }

    public final int read() throws IOException {
        int val;
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        int n = val = this.currentBuffer == null ? -1 : this.currentBuffer.read();
        if (val < 0) {
            val = this.refreshCurrentBuffer();
        }
        --this.remainingBytes;
        return val;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        int val = this.currentBuffer.read(b, off, len);
        if (val < 0) {
            this.currentBuffer = this.reader.readLOBContinuationStream(this.remainingBytes);
            val = this.currentBuffer.read(b, off, len);
        }
        this.remainingBytes -= (long)val;
        return val;
    }

    public final int available() {
        if (this.remainingBytes <= 0L) {
            return 0;
        }
        return this.currentBuffer.available();
    }

    final long getLength() {
        return this.length;
    }

    private int refreshCurrentBuffer() throws IOException {
        if (this.remainingBytes > 0L) {
            this.currentBuffer = this.reader.readLOBContinuationStream(this.remainingBytes);
            return this.currentBuffer.read();
        }
        return -1;
    }
}

