/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class CharConstantNode
extends ConstantNode {
    public void init(Object arg1) throws StandardException {
        if (arg1 instanceof TypeId) {
            super.init(arg1, Boolean.TRUE, ReuseFactory.getInteger(0));
        } else {
            String val = (String)arg1;
            super.init(TypeId.CHAR_ID, val == null ? Boolean.TRUE : Boolean.FALSE, val != null ? ReuseFactory.getInteger(val.length()) : ReuseFactory.getInteger(0));
            this.setValue(this.getDataValueFactory().getCharDataValue(val));
        }
    }

    public void init(Object newValue, Object newLength) throws StandardException {
        String val = (String)newValue;
        int newLen = (Integer)newLength;
        super.init(TypeId.CHAR_ID, val == null ? Boolean.TRUE : Boolean.FALSE, newLength);
        if (val.length() > newLen) {
            throw StandardException.newException("22001", (Object)"CHAR", (Object)val, (Object)String.valueOf(newLen));
        }
        while (val.length() < newLen) {
            val = val + ' ';
        }
        this.setValue(this.getDataValueFactory().getCharDataValue(val));
    }

    public String getString() throws StandardException {
        return this.value.getString();
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getString();
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.setCollationUsingCompilationSchema();
        this.value = ((StringDataValue)this.value).getValue(this.getLanguageConnectionContext().getDataValueFactory().getCharacterCollator(this.getTypeServices().getCollationType()));
        return this;
    }

    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.push(this.getString());
    }
}

