/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.AllocExtent;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.PageCreationArgs;
import org.apache.derby.impl.store.raw.data.StoredPage;

public class AllocPage
extends StoredPage {
    public static final int FORMAT_NUMBER = 118;
    private long nextAllocPageNumber;
    private long nextAllocPageOffset;
    private long reserved1;
    private long reserved2;
    private long reserved3;
    private long reserved4;
    private AllocExtent extent;
    private int borrowedSpace;
    protected static final int ALLOC_PAGE_HEADER_OFFSET = 60;
    protected static final int ALLOC_PAGE_HEADER_SIZE = 48;
    protected static final int BORROWED_SPACE_OFFSET = 108;
    protected static final int BORROWED_SPACE_LEN = 1;
    protected static final int MAX_BORROWED_SPACE = 204;
    public static final String TEST_MULTIPLE_ALLOC_PAGE = "TEST_MULTI_ALLOC_PAGE";

    public int getTypeFormatId() {
        return 118;
    }

    protected int getMaxFreeSpace() {
        return super.getMaxFreeSpace() - 48 - 1 - this.borrowedSpace;
    }

    protected void createPage(PageKey newIdentity, PageCreationArgs args) throws StandardException {
        this.borrowedSpace = args.containerInfoSize;
        super.createPage(newIdentity, args);
        SanityManager.ASSERT(true);
        if (this.borrowedSpace + 1 + 108 >= 204) {
            SanityManager.THROWASSERT("borrowedSpace too big = " + this.borrowedSpace);
        }
        SanityManager.ASSERT(this.pageData != null);
        this.pageData[108] = (byte)this.borrowedSpace;
        if (this.borrowedSpace > 0) {
            this.clearSection(109, this.borrowedSpace);
        }
        this.nextAllocPageNumber = -1L;
        this.nextAllocPageOffset = 0L;
        this.reserved4 = 0L;
        this.reserved3 = 0L;
        this.reserved2 = 0L;
        this.reserved1 = 0L;
        int maxFreeSpace = this.getMaxFreeSpace();
        SanityManager.ASSERT(this.totalSpace == maxFreeSpace, "totalSpace = " + this.totalSpace + ", getMaxFreeSpace() = " + maxFreeSpace);
        this.extent = this.createExtent(newIdentity.getPageNumber() + 1L, this.getPageSize(), 0, this.totalSpace);
    }

    private AllocExtent createExtent(long pageNum, int pageSize, int pagesAlloced, int availspace) {
        int maxPages = AllocExtent.MAX_RANGE(availspace);
        SanityManager.ASSERT(maxPages > 8, "cannot manage > 8 pages");
        if (SanityManager.DEBUG_ON(TEST_MULTIPLE_ALLOC_PAGE)) {
            maxPages = 2;
        }
        return new AllocExtent(pageNum * (long)pageSize, pageNum, pagesAlloced, pageSize, maxPages);
    }

    protected void initFromData(FileContainer myContainer, PageKey newIdentity) throws StandardException {
        int n;
        if (this.pageData.length < 109) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", newIdentity));
        }
        this.borrowedSpace = n = this.pageData[108];
        if (this.pageData.length < 109 + n) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", newIdentity));
        }
        if (this.borrowedSpace > 0) {
            this.clearSection(109, this.borrowedSpace);
        }
        super.initFromData(myContainer, newIdentity);
        try {
            this.readAllocPageHeader();
            int offset = 109 + this.borrowedSpace;
            this.extent = this.readExtent(offset);
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", ioe, (Object)newIdentity));
        }
        catch (ClassNotFoundException cnfe) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", cnfe, (Object)newIdentity));
        }
    }

    protected void writePage(PageKey identity) throws StandardException {
        try {
            this.updateAllocPageHeader();
            byte n = this.pageData[108];
            if (n != this.borrowedSpace) {
                SanityManager.THROWASSERT("different borrowed space " + n + ", " + this.borrowedSpace);
            }
            if (n > 0) {
                this.clearSection(109, n);
            }
            int offset = 109 + n;
            this.writeExtent(offset);
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", ioe, (Object)identity));
        }
        super.writePage(identity);
    }

    private void readAllocPageHeader() throws IOException {
        ArrayInputStream lrdi = this.rawDataIn;
        lrdi.setPosition(60);
        this.nextAllocPageNumber = lrdi.readLong();
        this.nextAllocPageOffset = lrdi.readLong();
        this.reserved1 = lrdi.readLong();
        this.reserved2 = lrdi.readLong();
        this.reserved3 = lrdi.readLong();
        this.reserved4 = lrdi.readLong();
    }

    private void updateAllocPageHeader() throws IOException {
        this.rawDataOut.setPosition(60);
        this.logicalDataOut.writeLong(this.nextAllocPageNumber);
        this.logicalDataOut.writeLong(this.nextAllocPageOffset);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
    }

    private AllocExtent readExtent(int offset) throws IOException, ClassNotFoundException {
        ArrayInputStream lrdi = this.rawDataIn;
        this.rawDataIn.setPosition(offset);
        AllocExtent newExtent = new AllocExtent();
        newExtent.readExternal(lrdi);
        int max_range = AllocExtent.MAX_RANGE(this.getMaxFreeSpace());
        long extent_start = newExtent.getFirstPagenum();
        long extent_end = newExtent.getExtentEnd();
        if (extent_start + (long)max_range - 1L < extent_end) {
            SanityManager.THROWASSERT("extent range exceed what extent's space can handle ");
        }
        return newExtent;
    }

    private void writeExtent(int offset) throws IOException {
        this.rawDataOut.setPosition(offset);
        this.extent.writeExternal(this.logicalDataOut);
    }

    public static void WriteContainerInfo(byte[] containerInfo, byte[] epage, boolean create) throws StandardException {
        int N;
        int n = N = containerInfo == null ? 0 : containerInfo.length;
        if (create) {
            SanityManager.ASSERT(containerInfo != null, "containerInfo is null");
        }
        SanityManager.ASSERT(epage != null, "page array is null");
        if (containerInfo != null && containerInfo.length + 108 + 1 >= epage.length) {
            SanityManager.THROWASSERT("containerInfo too big for page array: " + containerInfo.length);
        }
        if (109 + N >= 204) {
            SanityManager.THROWASSERT("exceed max borrowable space: " + N);
        }
        if (N + 1 + 108 > epage.length) {
            SanityManager.THROWASSERT("exceed max borrowable space on page: " + N);
        }
        if (create) {
            epage[108] = (byte)N;
        } else {
            byte oldN = epage[108];
            if (oldN != N) {
                throw StandardException.newException("XSDB3.D", (Object)new Long(oldN), (Object)new Long(N));
            }
        }
        if (N != 0) {
            System.arraycopy(containerInfo, 0, epage, 109, N);
        }
    }

    public static void ReadContainerInfo(byte[] containerInfo, byte[] epage) {
        byte N = epage[108];
        if (N != containerInfo.length) {
            SanityManager.THROWASSERT("N not what is expected : " + N);
        }
        if (109 + N >= 204) {
            SanityManager.THROWASSERT("exceed max borrowable space: " + N);
        }
        if (N != 0) {
            System.arraycopy(epage, 109, containerInfo, 0, N);
        }
    }

    public long nextFreePageNumber(long pnum) {
        return this.extent.getFreePageNumber(pnum);
    }

    public void addPage(FileContainer mycontainer, long newPageNumber, RawTransaction ntt, BaseContainerHandle userHandle) throws StandardException {
        this.owner.getAllocationActionSet().actionAllocatePage(ntt, this, newPageNumber, 0, 2);
    }

    public void deallocatePage(BaseContainerHandle userHandle, long pageNumber) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        this.owner.getAllocationActionSet().actionAllocatePage(userHandle.getTransaction(), this, pageNumber, 1, 0);
    }

    protected void updateUnfilledPageInfo(AllocExtent inputExtent) {
        SanityManager.ASSERT(this.isLatched());
        this.extent.updateUnfilledPageInfo(inputExtent);
    }

    public boolean canAddFreePage(long lastAllocatedPage) {
        SanityManager.ASSERT(this.isLatched());
        if (this.extent.isRetired()) {
            return false;
        }
        if (lastAllocatedPage != -1L && this.extent.getLastPagenum() <= lastAllocatedPage && !this.isLast()) {
            return false;
        }
        return this.extent.canAddFreePage(lastAllocatedPage);
    }

    public long getNextAllocPageOffset() {
        SanityManager.ASSERT(!this.isLast(), "next alloc page not present for last alloc page");
        SanityManager.ASSERT(this.isLatched());
        return this.nextAllocPageOffset;
    }

    public void chainNewAllocPage(BaseContainerHandle allocHandle, long newAllocPageNum, long newAllocPageOffset) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (SanityManager.DEBUG_ON(FileContainer.SPACE_TRACE)) {
            SanityManager.DEBUG(FileContainer.SPACE_TRACE, "chaining new alloc page " + newAllocPageNum + " to " + this.getPageNumber());
        }
        this.owner.getAllocationActionSet().actionChainAllocPage(allocHandle.getTransaction(), this, newAllocPageNum, newAllocPageOffset);
    }

    public long getNextAllocPageNumber() {
        SanityManager.ASSERT(this.isLatched());
        SanityManager.ASSERT(!this.isLast(), "next alloc page not present for last alloc page");
        return this.nextAllocPageNumber;
    }

    public boolean isLast() {
        SanityManager.ASSERT(this.isLatched());
        return this.nextAllocPageNumber == -1L;
    }

    public long getLastPagenum() {
        SanityManager.ASSERT(this.isLatched());
        return this.extent.getLastPagenum();
    }

    public long getMaxPagenum() {
        return this.extent.getExtentEnd();
    }

    protected long getLastPreallocPagenum() {
        SanityManager.ASSERT(this.isLatched());
        return this.extent.getLastPreallocPagenum();
    }

    protected int getPageStatus(long pageNumber) {
        SanityManager.ASSERT(this.isLatched());
        return this.extent.getPageStatus(pageNumber);
    }

    protected void setPageStatus(LogInstant instant, long pageNumber, int newStatus) throws StandardException {
        SanityManager.ASSERT(this.isLatched(), "page is not latched");
        SanityManager.ASSERT(this.extent != null, "extent is null");
        this.logAction(instant);
        switch (newStatus) {
            case 0: {
                this.extent.allocPage(pageNumber);
                break;
            }
            case 1: {
                this.extent.deallocPage(pageNumber);
                break;
            }
            case 2: {
                this.extent.deallocPage(pageNumber);
            }
        }
    }

    protected void chainNextAllocPage(LogInstant instant, long newAllocPageNum, long newAllocPageOffset) throws StandardException {
        SanityManager.ASSERT(this.isLatched(), "page is not latched");
        this.logAction(instant);
        this.nextAllocPageNumber = newAllocPageNum;
        this.nextAllocPageOffset = newAllocPageOffset;
    }

    protected void compressSpace(LogInstant instant, int new_highest_page, int num_pages_truncated) throws StandardException {
        SanityManager.ASSERT(this.isLatched(), "page is not latched");
        SanityManager.ASSERT(this.isLast(), "compress on non last alloc page.");
        SanityManager.ASSERT(new_highest_page >= -1, "negative new high page.");
        this.logAction(instant);
        this.extent.compressPages(new_highest_page, num_pages_truncated);
    }

    protected void undoCompressSpace(LogInstant instant, int new_highest_page, int num_pages_truncated) throws StandardException {
        this.logAction(instant);
        this.extent.undoCompressPages(new_highest_page, num_pages_truncated);
    }

    public String toString() {
        String str = "*** Alloc page ***\nnextAllocPageNumber = " + this.nextAllocPageNumber + "\nnextAllocPageOffset = " + this.nextAllocPageOffset + "\nreserved1 = " + this.reserved1 + "\nreserved2 = " + this.reserved2 + "\nreserved3 = " + this.reserved3 + "\nreserved4 = " + this.reserved4 + "\nborrowedSpace = " + this.borrowedSpace + "\nextent = " + this.extent.toDebugString() + "\n" + super.toString();
        return str;
    }

    protected AllocExtent getAllocExtent() {
        return this.extent;
    }

    protected void preAllocatePage(FileContainer myContainer, int preAllocThreshold, int preAllocSize) {
        SanityManager.ASSERT(this.isLatched(), "page is not latched");
        long lastPreallocatedPagenum = this.extent.getLastPreallocPagenum();
        if (lastPreallocatedPagenum < (long)preAllocThreshold) {
            return;
        }
        if (this.extent.getExtentEnd() < lastPreallocatedPagenum + (long)preAllocSize) {
            preAllocSize = (int)(this.extent.getExtentEnd() - lastPreallocatedPagenum);
        }
        if (preAllocSize <= 0) {
            return;
        }
        int n = myContainer.preAllocate(lastPreallocatedPagenum, preAllocSize);
        if (n > 0) {
            this.extent.setLastPreallocPagenum(lastPreallocatedPagenum + (long)n);
        }
    }

    protected boolean compress(RawTransaction ntt, FileContainer myContainer) throws StandardException {
        boolean all_pages_compressed = false;
        SanityManager.ASSERT(this.isLatched(), "page is not latched");
        int last_valid_page = this.extent.compress(this.owner, ntt, this);
        if (last_valid_page >= 0) {
            myContainer.truncatePages(this.extent.getPagenum(last_valid_page));
            if ((long)last_valid_page == this.getPageNumber()) {
                all_pages_compressed = true;
            }
        }
        return all_pages_compressed;
    }
}

