/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.buffer;

import org.apache.derby.iapi.services.sanity.SanityManager;

class LogBufferElement {
    private final byte[] bufferdata;
    private int position;
    private long greatestInstant;
    private boolean recycleMe;

    protected LogBufferElement(int bufferSize) {
        this.bufferdata = new byte[bufferSize];
        this.init();
    }

    protected void init() {
        this.position = 0;
        this.greatestInstant = 0L;
        this.recycleMe = true;
    }

    protected void appendLog(long greatestInstant, byte[] log, int logOffset, int logLength) {
        SanityManager.ASSERT(this.freeSize() >= logLength, "Log chunk does not fit into this LogBufferElement");
        this.greatestInstant = greatestInstant;
        this.position = this.appendBytes(log, logOffset, this.position, logLength);
    }

    protected byte[] getData() {
        return this.bufferdata;
    }

    protected long getLastInstant() {
        return this.greatestInstant;
    }

    protected int freeSize() {
        return this.bufferdata.length - this.position;
    }

    protected int size() {
        return this.position;
    }

    protected boolean isRecyclable() {
        return this.recycleMe;
    }

    protected void setRecyclable(boolean r) {
        this.recycleMe = r;
    }

    private int appendBytes(byte[] b, int offset, int pos, int length) {
        SanityManager.ASSERT(this.freeSize() >= length, "byte[] is to big to fit into this buffer");
        SanityManager.ASSERT(b != null, "Cannot append null to buffer");
        System.arraycopy(b, offset, this.bufferdata, pos, length);
        return pos + length;
    }
}

