/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.admin.ui.cloud.internal.CloudConfigurationPage;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutDataFactory;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutFactory;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeConfigurer;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NodeConnectionSection
extends SectionPart {
    private final CloudConfigurationPage page;
    private Text connectStringText;
    private Button cloudMemberButton;
    private Text nodeIdText;
    private Button connectButton;

    public NodeConnectionSection(CloudConfigurationPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.page = page;
        this.createContent(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    void connectButtonPressed() {
        ICloudManager cloudManager = this.getCloudManager();
        INodeConfigurer nodeConfigurer = cloudManager.getNodeConfigurer(cloudManager.getLocalInfo().getNodeId());
        IStatus status = this.cloudMemberButton.getSelection() ? nodeConfigurer.configureConnection(this.connectStringText.getText()) : nodeConfigurer.configureConnection(null);
        if (!status.isOK()) {
            Policy.getStatusHandler().show(status, "Error Configuring Node");
        }
    }

    private void createContent(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        section.setText("Node Information");
        section.setDescription("This section describes the general information about the local node.");
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)3));
        FormLayoutDataFactory.applyDefaults((Composite)client, (int)1);
        Label idLabel = toolkit.createLabel(client, "Node Id");
        this.nodeIdText = toolkit.createText(client, "", 12);
        FormLayoutDataFactory.applyDefaults((Label)idLabel, (int)1);
        FormLayoutDataFactory.applyDefaults((Text)this.nodeIdText, (int)2);
        Label modeLabel = toolkit.createLabel(client, "Membership");
        this.cloudMemberButton = toolkit.createButton(client, "The local node is a member of a cloud.", 32);
        FormLayoutDataFactory.applyDefaults((Label)modeLabel, (int)1);
        FormLayoutDataFactory.applyDefaults((Button)this.cloudMemberButton, (int)2);
        Label cloudLabel = toolkit.createLabel(client, "Connection String:");
        this.connectStringText = toolkit.createText(client, "");
        this.connectButton = toolkit.createButton(client, "Connect", 8);
        FormLayoutDataFactory.applyDefaults((Label)cloudLabel, (int)1);
        FormLayoutDataFactory.applyDefaults((Text)this.connectStringText, (int)1);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeConnectionSection.this.connectButtonPressed();
            }
        });
        DataBindingContext bindingContext = this.page.getBindingContext();
        ISWTObservableValue cloudMemberSelectionValue = SWTObservables.observeSelection((Control)this.cloudMemberButton);
        bindingContext.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.connectStringText), (IObservableValue)cloudMemberSelectionValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        bindingContext.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.connectButton), (IObservableValue)cloudMemberSelectionValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
    }

    protected ICloudManager getCloudManager() {
        return (ICloudManager)this.getManagedForm().getInput();
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
    }

    public void refresh() {
        ICloudManager cloudManager = this.getCloudManager();
        INodeEnvironment localInfo = cloudManager.getLocalInfo();
        this.nodeIdText.setText(localInfo.getNodeId());
        this.cloudMemberButton.setSelection(!localInfo.inStandaloneMode());
        INodeConfigurer nodeConfigurer = cloudManager.getNodeConfigurer(localInfo.getNodeId());
        this.connectStringText.setText(StringUtils.trimToEmpty((String)nodeConfigurer.getConnectionString()));
        super.refresh();
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ICloudManager) {
            this.markStale();
            return true;
        }
        return super.setFormInput(input);
    }
}

