/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.Locale;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobLog;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class JobsLabelProvider
extends LabelProvider {
    private ResourceManager manager;

    public void dispose() {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
        super.dispose();
    }

    private ImageDescriptor getElementImage(ISchedule element) {
        if (element.isEnabled()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
    }

    private ImageDescriptor getElementImage(JobLog element) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        if (element.isError()) {
            return sharedImages.getImageDescriptor("IMG_OBJS_ERROR_TSK");
        }
        if (element.isWarning()) {
            return sharedImages.getImageDescriptor("IMG_OBJS_WARN_TSK");
        }
        return null;
    }

    private String getElementText(ISchedule element) {
        if (element.isEnabled()) {
            return String.format("%s (%s, %d)", element.getId(), element.getTimeZone().getDisplayName(Locale.US), element.getEntries().size());
        }
        return String.format("%s (DISABLED)", element.getId());
    }

    private String getElementText(IScheduleEntry element) {
        return String.format("%s (%s, %s)", element.getId(), element.getCronExpression(), element.getJobTypeId());
    }

    private String getElementText(JobLog element) {
        return element.getId();
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = this.getImageDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        return this.getResourceManager().createImage(descriptor);
    }

    private ImageDescriptor getImageDescriptor(Object element) {
        if (element instanceof ISchedule) {
            return this.getElementImage((ISchedule)element);
        }
        if (element instanceof JobLog) {
            return this.getElementImage((JobLog)element);
        }
        return null;
    }

    private ResourceManager getResourceManager() {
        if (this.manager == null) {
            this.manager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.manager;
    }

    public String getText(Object element) {
        if (element instanceof ISchedule) {
            return this.getElementText((ISchedule)element);
        }
        if (element instanceof IScheduleEntry) {
            return this.getElementText((IScheduleEntry)element);
        }
        if (element instanceof JobLog) {
            return this.getElementText((JobLog)element);
        }
        return super.getText(element);
    }
}

